% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf_mat_resampled.R
\name{conf_mat_resampled}
\alias{conf_mat_resampled}
\title{Compute average confusion matrix across resamples}
\usage{
conf_mat_resampled(x, parameters = NULL, tidy = TRUE)
}
\arguments{
\item{x}{An object with class \code{tune_results} that was used with a
classification model that was run with \code{control_*(save_pred = TRUE)}.}

\item{parameters}{A tibble with a single tuning parameter combination. Only
one tuning parameter combination (if any were used) is allowed here.}

\item{tidy}{Should the results come back in a tibble (\code{TRUE}) or a matrix.}
}
\value{
A tibble or matrix with the average cell count across resamples.
}
\description{
For classification problems, \code{conf_mat_resampled()} computes a separate
confusion matrix for each resample then averages the cell counts.
}
\examples{
library(parsnip)
library(rsample)
library(dplyr)

data(two_class_dat, package = "modeldata")

set.seed(2393)
res <-
  logistic_reg() \%>\%
  set_engine("glm") \%>\%
  fit_resamples(Class ~ ., resamples = vfold_cv(two_class_dat, v = 3),
                control = control_resamples(save_pred = TRUE))

conf_mat_resampled(res)
conf_mat_resampled(res, tidy = FALSE)
}
