% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv2.R
\name{cv2}
\alias{cv2}
\title{Calculates various measures of population and community variability}
\usage{
cv2(X, type)
}
\arguments{
\item{X}{A matrix with counts or densities arranged in species by time step}

\item{type}{If \code{pop}, calculate CVpop2. If \code{com}, calculate CVcom2. If \code{comip},
calculate CVcomip2. See the vignette for definitions of these quantities.}
}
\value{
\code{cv2} returns the value of population or community variability.
}
\description{
Calculates various measures of population and community variability
}
\examples{
X<-matrix(runif(200,1,100), 10, 20)
ans<-cv2(X, type="com")

}
\references{
Zhao et al, (In prep) Decomposition of the variance ratio illuminates timescale-specific
population and community variability.
}
\seealso{
\code{\link{vreq_classic}}, \code{\link{vreq_LdM}}, \code{\link{cv2f}}, \code{browseVignettes("tsvr")}
}
\author{
Lei Zhao, \email{lei.zhao@cau.edu.cn}; Daniel Reuman, \email{reuman@ku.edu}; Shaopeng Wang, \email{shaopeng.wang@pku.edu.cn}
}
