% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_daily.R
\name{.stretch_re}
\alias{.stretch_re}
\title{Use time warping to reduce the number of observations in a month}
\usage{
.stretch_re(seas_component)
}
\arguments{
\item{seas_component}{Seasonal component for day-of-the-month}
}
\value{
Returns a \code{xts} time series containing the day-of-the-month effect.
}
\description{
Reduce the number of observations in a month using time warping / stretching. Only relevant if a daily time series is simulated
}
\details{
Usually time warping would be used to stretch the number of observations of a time series in a given interval to more observations. Here it is used to reduce the number of observations (31) to the number of days in a given month while maintaining the underlying trajectory of the data. This is done by first creating a very long time series for each month, interpolating missing values by spline interpolation and then reducing the number of observations to the number suitable for a given month.
}
\references{
Ollech, D. (2021). Seasonal adjustment of daily time series. Journal of Time Series Econometrics. \doi{10.1515/jtse-2020-0028}
}
\author{
Daniel Ollech
}
