% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.compare_gvar}
\alias{print.compare_gvar}
\title{Print method for compare_gvar objects}
\usage{
\method{print}{compare_gvar}(x, ...)
}
\arguments{
\item{x}{A test object obtained from [compare_gvar()]}

\item{...}{Additional arguments to be passed to the print method. (currently not used)}
}
\value{
Prints a summary of the Norm-Based Comparison Test to the console
}
\description{
This function prints a summary of the Norm-Based Comparison Test for a [compare_gvar()] object.
}
\details{
This function prints a summary of the Norm-Based Comparison Test for a [compare_gvar()] object.
in the temporal and contemporaneous networks, as well as the number of reference distances that were larger
than the empirical distance for each network.
}
\examples{
# Load example fits
data(fit_data)

# Perform test
test_res <- compare_gvar(fit_data[[1]], fit_data[[2]], n_draws = 100)

# Print results
print(test_res)

}
