% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass.R
\name{mass}
\alias{mass}
\title{Calculates the distance profile using MASS algorithm}
\usage{
mass(data_fft, query_window, data_size, window_size, data_mean, data_sd,
  query_mean, query_sd)
}
\arguments{
\item{data_fft}{precomputed data product.}

\item{query_window}{a \code{vector} of \code{numeric}. Query window.}

\item{data_size}{an \code{int}. The length of the reference data.}

\item{window_size}{an \code{int}. Sliding window size.}

\item{data_mean}{precomputed data moving average.}

\item{data_sd}{precomputed data moving standard deviation.}

\item{query_mean}{precomputed query average.}

\item{query_sd}{precomputed query standard deviation.}
}
\value{
Returns the \code{distance_profile} for the given query and the \code{last_product} for STOMP
algorithm.
}
\description{
Mueen's Algorithm for Similarity Search is The Fastest Similarity Search Algorithm for Time
Series Subsequences under Euclidean Distance and Correlation Coefficient.
}
\examples{
w <- mp_toy_data$sub_len
ref_data <- mp_toy_data$data[, 1]
query_data <- mp_toy_data$data[, 1]
d_size <- length(ref_data)
q_size <- length(query_data)

pre <- mass_pre(ref_data, d_size, query_data, q_size, w)

dp <- list()
for (i in 1:(d_size - w + 1)) {
  dp[[i]] <- mass(
    pre$data_fft, query_data[i:(i - 1 + w)], d_size, w, pre$data_mean, pre$data_sd,
    pre$query_mean[i], pre$query_sd[i]
  )
}
}
\references{
\itemize{
\item Abdullah Mueen, Yan Zhu, Michael Yeh, Kaveh Kamgar, Krishnamurthy Viswanathan,
Chetan Kumar Gupta and Eamonn Keogh (2015), The Fastest Similarity Search Algorithm for Time
Series Subsequences under Euclidean Distance
}

Website: \url{https://www.cs.unm.edu/~mueen/FastestSimilaritySearch.html}
}
\seealso{
\code{\link[=mass_pre]{mass_pre()}} to precomputation of input values.
}
