% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting.R
\name{grnn_forecasting}
\alias{grnn_forecasting}
\title{Time series forecasting using GRNN regression}
\usage{
grnn_forecasting(timeS, h, lags = NULL, sigma = NULL,
  msas = c("recursive", "MIMO"), scale = TRUE)
}
\arguments{
\item{timeS}{A numeric vector or time series of class \code{ts}.}

\item{h}{A positive integer. Number of periods for forecasting.}

\item{lags}{An integer vector in increasing order expressing the lags used as
autoregressive variables.}

\item{sigma}{A positive real value. The smoothing parameter in GRNN
regression. If NULL (the default) the parameter is chosen using an
optimization tool.}

\item{msas}{A string indicating the Multiple-Step Ahead Strategy used when
more than one value is predicted. It can be "MIMO" or "recursive" (the
default).}

\item{scale}{A logical. If \code{TRUE} (the default), the time series is
scaled to the range [0, 1].}
}
\value{
An object of class \code{"grnnForecast"}. The function
  \code{\link[base]{summary}} can be used to obtain or print a summary of the
  results. An object of class \code{"gnnForecast"} is a list containing at
  least the following components:

  \item{\code{call}}{the matched call.} \item{\code{msas}}{the Multi-Step
  Ahead Strategy.} \item{\code{prediction}}{a time series with the forecast.}
  \item{\code{model}}{an object of class \code{"grnnModel"} with the GRNN
  model}
}
\description{
It applies GRNN regression to forecast the future values of a time series.
The lags used as autoregressive variables are set with the \code{lags}
parameter. If the user does not set the lags, these values are selected
automatically.
}
\examples{
pred <- grnn_forecasting(USAccDeaths, h = 12, lags = 1:12)
plot(pred)
}
