% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dec.sim.R
\name{dec.sim}
\alias{dec.sim}
\title{run dose-finding simulations}
\usage{
dec.sim(truep, decTable, start.level = 1, nsim = 1000)
}
\arguments{
\item{truep}{a vector of length k (the number of doses being considered in the trial), with values equal to the true probabilities of toxicity at the dose levels.}

\item{decTable}{a customized decision table. (same format as output of \code{\link{dec.table}})}

\item{start.level}{starting dose level. Defaults to 1, i.e. the lowest dose level.}

\item{nsim}{the number of simulation trials. Defaults to 1000.}
}
\value{
the functions \code{\link{summary.dec.sim}} is used to obtain and print a summary table of the results (recommended). An object of class \code{"dec.sim"} is a list containing:
 \item{mtd}{a vector of dose levels giving the recommended maximum tolerated dose (MTD) at the end of the trial.}
 \item{mtd.prob}{a vector of length \code{k} giving the average proportions of selected as MTD at each dose level.}
 \item{over.prob}{a vector of length \code{k} giving the average proportions of selected as over the MTD at each dose level.}
 \item{n.patients}{the average number of patients dosed at each level.}
 \item{dlt}{the average number of DLTs experienced at each dose level.}
 \item{truep}{input; true probabilities of toxicity.}
 \item{start.level}{input; starting dose level.}
 \item{nsim}{input; number of simulated trails.}
}
\description{
Run dose-finding simulations based on a customized decision table.
}
\details{
Assume there are $d$ dose levels to be studied. Denote the cumulative number of patients treated and cumulative number of DLTs at the current dose level are $n_i$ and $m_i$, respectively. $n_{max}$ is the maximum number of patients permitted to be treated at each dose level. The procedure is as follows
\itemize{
\item{Step 1 : }{Update cumulative number of DLTs $m_i$ and total number of patients $n_i$ treated at the current dose and use the decision table to make a decision: if decision is ``S" --> step 2; if decision is ``D" or ``DU'' --> step 3; if decision is ``E'' --> step 4}
\item{Step 2 : }{If $n_i = n_{max}$, declare dose i as the MTD; otherwise, update $m_i$ and $n_i$ with additional cohort of patients and go to Step 1.}
\item{Step 3 : }{If the current dose level is the highest dose level, then: if n_i < n_max, update $m_i$ and $n_i$ with additional cohort of patients and go to Step 1; otherwise, stop the trial and declare that the MTD is higher than the highest dose level (inconclusive); If the current dose is not the lowest dose, then: if $n_{i-1} < n_{max}$, update $m_{i-1}$ and $n_{i-1}$ with additional cohort of patients and set the current dose level to be the next lower dose level, and go to Step 1; otherwise, stop the trial and declare the next lower dose level is the MTD; Additionally, if the decision is ``DU'', record this dose level as DU and never treat additional patients at the current dose level again.}
\item{Step 4 : }{If the current dose level is the highest dose level, then: if $n_i < n_{max}$, update $m_i$ and $n_i$ with additional cohort of patients and go to Step 1; otherwise, stop the trial and declare that the MTD is higher than the highest dose level (inconclusive); If the next higher dose level is of status DU, then: if $n_i < n_{max}$, update $m_i$ and $n_i$ with additional cohort of patients and go to step 1; otherwise stop, the current dose level is MTD; Otherwise: if $n_{i+1} < n_{max}$, update $m_{i+1}$ and  $n_{i+1}$ with additional cohort of patients, set the current dose level to be next higher dose level, and go to step 1; else, the current dose level is the MTD. }
}
}
\examples{
truep <- c(0.3, 0.45, 0.5, 0.6)
res <- dec.table(0.6,0.4,0.2,0.3,c(3,3,3))
out <- dec.sim(truep, res$table, start.level = 2, nsim = 1000)
summary(out, pt = 0.3)
}
\author{
Wenchuan Guo <wguo007@ucr.edu>
}
