% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_plot.R
\name{ts_plot}
\alias{ts_plot}
\title{Plot Time Series}
\usage{
ts_plot(..., title, subtitle, ylab = "", family = getOption("ts_font", "sans"))
}
\arguments{
\item{...}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo},
\code{zooreg}, \code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, \code{tis},
\code{irts} or \code{timeSeries}.}

\item{title}{title (optional)}

\item{subtitle}{subtitle (optional)}

\item{ylab}{ylab (optional)}

\item{family}{font family (optional, can also be set via \code{options})}
}
\description{
\code{ts_plot()} is a fast and simple plotting function for ts-boxable time
series, with limited customizability. For more theme options, use
\code{\link[=ts_ggplot]{ts_ggplot()}}.
}
\details{
Both \code{ts_plot()} and \code{\link[=ts_ggplot]{ts_ggplot()}} combine multiple ID dimensions into a
single dimension. To plot multiple dimensions in different shapes, facets,
etc., use standard ggplot.

Limited customizability of \code{ts_plot} is available via options. See examples.
}
\examples{
\donttest{
ts_plot(
  AirPassengers,
  title = "Airline passengers",
  subtitle = "The classic Box & Jenkins airline data"
)

# naming arguments
ts_plot(total = ldeaths, female = fdeaths, male = mdeaths)

# using different ts-boxable objects
ts_plot(ts_scale(ts_c(
  ts_xts(airmiles),
  ts_tbl(co2),
  JohnsonJohnson,
  ts_df(discoveries)
)))

# customize ts_plot
op <- options(
  tsbox.lwd = 3,
  tsbox.col = c("gray51", "gray11"),
  tsbox.lty = "dashed"
)
ts_plot(
  "Female" = fdeaths,
  "Male" = mdeaths
)
options(op) # restore defaults
}
}
\seealso{
\code{\link[=ts_ggplot]{ts_ggplot()}}, for a plotting function based on ggplot2.
\code{\link[=ts_dygraphs]{ts_dygraphs()}}, for interactive time series plots. \code{\link[=ts_save]{ts_save()}} to
save a plot to the file system.
}
