% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_from_data.frame.R, R/to_from_data.table.R,
%   R/to_from_tibble.R, R/to_from_tibbletime.R, R/to_from_timeSeries.R,
%   R/to_from_ts.R, R/to_from_tsibble.R, R/to_from_tslist.R, R/to_from_xts.R,
%   R/to_from_zoo.R
\name{ts_ts}
\alias{ts_ts}
\alias{ts_data.frame}
\alias{ts_ts}
\alias{ts_df}
\alias{ts_ts}
\alias{ts_data.table}
\alias{ts_ts}
\alias{ts_dt}
\alias{ts_ts}
\alias{ts_tbl}
\alias{ts_ts}
\alias{ts_tibbletime}
\alias{ts_ts}
\alias{ts_timeSeries}
\alias{ts_ts}
\alias{ts_ts}
\alias{ts_tsibble}
\alias{ts_ts}
\alias{ts_tslist}
\alias{ts_ts}
\alias{ts_xts}
\alias{ts_ts}
\alias{ts_zoo}
\title{Convert Everything to Everything}
\usage{
ts_data.frame(x)

ts_df(x)

ts_data.table(x)

ts_dt(x)

ts_tbl(x)

ts_tibbletime(x)

ts_timeSeries(x)

ts_ts(x)

ts_tsibble(x)

ts_tslist(x)

ts_xts(x)

ts_zoo(x)
}
\arguments{
\item{x}{ts-boxable time series, an object of class \code{ts}, \code{xts}, \code{zoo}, \code{data.frame}, \code{data.table}, \code{tbl}, \code{tbl_ts}, \code{tbl_time}, or \code{timeSeries}.}
}
\value{
ts-boxable time series of the desired class, an object of class \code{ts}, \code{xts}, \code{data.frame}, \code{data.table}, or \code{tibble}.
}
\description{
tsbox is built around a set of converters, which convert time series
stored as \code{ts}, \code{xts}, \code{data.frame}, \code{data.table} or \code{tibble} to each
other.
}
\details{
In data frames, multiple time series will be stored in a 'long' format. tsbox
detects a \emph{value}, a \emph{time} and zero to several \emph{id} columns. Column detection
is done in the following order:
\enumerate{
\item Starting \strong{on the right}, the first first \code{numeric} or \code{integer} column is
used as \strong{value column}.
\item Using the remaining columns, and starting on the right again, the first
\code{Date}, \code{POSIXct}, \code{numeric} or \code{character} column is used as \strong{time column}.
\code{character} strings are parsed by \code{\link[anytime:anytime]{anytime::anytime()}}.
The time stamp, \code{time}, indicates the beginning of a period.
\item \strong{All remaining} columns are \strong{id columns}. Each unique combination of id
columns points to a time series.
}

\strong{Alternatively}, the \strong{time} column and the \strong{value} column to be explicitly named as
\code{time} and \code{value}. If explicit names are used, the column order will be
ignored.

Whenever possible, tsbox relies on \strong{heuristic time conversion}. When a
monthly \code{"ts"} time series, e.g., \code{AirPassengers}, is converted to a data
frame, each time stamp (of class \code{"Date"}) is the first day of the month. In
most circumstances, this reflects the actual meaning of the data stored in a
\code{"ts"} object. Technically, of course, this is not correct: \code{"ts"} objects
divide time in period of equal length, while in reality, February is shorter
than January. Heuristic conversion is done for frequencies of 0.1 (decades),
1 (years), 4 (quarters) and 12 (month).

For other frequencies, e.g. 260, of \code{EuStockMarkets}, tsbox uses  \strong{exact
time conversion}. The year is divided into 260 equally long units, and time
stamp of a period will be a point in time (of class \code{"POSIXct"}).
}
\examples{

x.ts <- ts_c(mdeaths, fdeaths)
head(x.ts)
head(ts_df(x.ts))

suppressMessages(library(dplyr))
head(ts_tbl(x.ts))

suppressMessages(library(data.table))
head(ts_dt(x.ts))

suppressMessages(library(xts))
head(ts_xts(x.ts))

# heuristic time conversion
# 1 momth: approx. 1/12 year
head(ts_df(AirPassengers))

# exact time conversion
# 1 trading day: exactly 1/260 year
head(ts_df(EuStockMarkets))

# multiple id
multi.id.df <- rbind(
  within(ts_df(ts_c(fdeaths, mdeaths)), type <- "level"),
  within(ts_pc(ts_df(ts_c(fdeaths, mdeaths))), type <- "pc")
)
head(ts_ts(multi.id.df))
ts_plot(multi.id.df)

}
