% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_dist.R
\name{tsdist_ccf}
\alias{tsdist_ccf}
\title{Cross-correlation distance}
\usage{
tsdist_ccf(
  ts1,
  ts2,
  type = c("correlation", "covariance"),
  cor_type = "abs",
  directed = FALSE,
  lag_max = 10,
  return_lag = FALSE
)
}
\arguments{
\item{ts1}{Array. Time series 1}

\item{ts2}{Array. Time series 2}

\item{type}{String. "correlation" or "covariance" to be used (type) in the ccf function.}

\item{cor_type}{String. "abs" (default), "+", or "-". "abs" considers the
correlation absolute value. "+" only positive correlations and "-" only
negative correlations.}

\item{directed}{Boolean. If FALSE (default), the lag interval [-lag_max,+lag_max] is
considered. Otherwise, [-lag_max,0] is considered.}

\item{lag_max}{Integer. Default = 10.}

\item{return_lag}{Also returns the time lag that leads to the shortest distances.}
}
\value{
Distance
}
\description{
Minimum correlation distance considering a +- max lag  (lag_max)
}
