% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensity.R
\name{intensity}
\alias{intensity}
\title{Compute the spectral intensity of a time-series vector/matrix}
\usage{
intensity(
  x,
  centered = TRUE,
  centred = centered,
  scaled = TRUE,
  nyquist = TRUE
)
}
\arguments{
\item{x}{A vector of time-series values}

\item{centered}{Logical; if \code{TRUE} the time-series vector is centred (mean removed) before computing its intensity}

\item{centred}{An alternative name for the \code{centered} input}

\item{scaled}{Logical; if \code{TRUE} the intensity measure is scaled so that its norm is equal to the number of values in the time-series}

\item{nyquist}{Logical; if \code{TRUE} the intensity vector is reduces for real time-series vectors to limit it to frequencies in the Nyquist range}
}
\description{
This function computes the spectral intensity of a time series vector/matrix.  The user inputs the time-series vector or matrix and specifies
whether it is to be centered and/or scaled.  Centering subtracts the sample mean of the vector prior to conversion into frequency space; this
sets the intensity of the signal to zero at the zero frequency.  Scaling scales the intensity so the that norm of the intensity vector is equal
to the number of values in the time-series.
}
\examples{

data(garma)
intensity(SERIES1)
}
