% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tropicalsparse.mul.R
\name{tropicalsparse.mul}
\alias{tropicalsparse.mul}
\title{Multiplication With or Without Storage Techniques}
\usage{
tropicalsparse.mul(A, B, store = NULL, algebraType)
}
\arguments{
\item{A}{is matrix or vector.}

\item{B}{is matrix or vector.}

\item{store}{is storage technique.}

\item{algebraType}{is string input that can be \code{minplus} or \code{maxplus}.}
}
\value{
Multiplication of \code{A} and \code{B} in Tropical Algebra.
}
\description{
\code{tropicalsparse.mul} function multiplies the provided inputs in Tropical Algebra based on
type of Tropical Algebra.
}
\details{
The compulsory inputs of the function \code{tropicalsparse.mul} are \code{A}, \code{B} and
\code{algebraType} while the remaining input is optional that is \code{store}. The inputs \code{A} and
\code{B} can be matrix/matrix, matrix/vector, vector/matrix and vector/vector otherwise the function generates
an error. For \code{A} and \code{B}, the order of the input does not matter. It can be in any of the following
way: the first input of the function is matrix and second input is a vector. Similarly, vise versa.
\code{store} can be \code{coo}, \code{csc} and \code{csr} for applying following storage techniques
respectively: Coordinate-Wise, Compressed Sparse Row, Compressed Sparse Column. This input is case sensitive.
If the \code{store} input is other than the specified storage techniques then the function generates an error.
The input \code{algebraType} is used to specify type of Tropical Algebra. This can be \code{minplus} or
\code{maxplus}. For more details about \code{algebraType}, see \code{detail} section of
\code{\link{check.infinityM}} or \code{\link{check.infinityV}}. \code{\link{tropicalsparse.storage}}
function is used to apply storage technique depends upon the input given. If \code{store} input is not
specified then the functionality will be performed without using any storage technique.
}
\examples{
a <- matrix(data = c(2, Inf, Inf, 0, Inf, Inf, Inf, 10, Inf),
nrow = 3, ncol = 3, byrow = TRUE)

b <- matrix(data = c(Inf, Inf, 4, Inf, -0.3, Inf, Inf, 2, Inf),
nrow = 3, ncol = 3, byrow = TRUE)

tropicalsparse.mul(a, b, 'csr', 'minplus')

#      [,1] [,2] [,3]
# [1,]  Inf  Inf    6
# [2,]  Inf  Inf    4
# [3,]  Inf  9.7  Inf

# also

a <- matrix(data = c(5, -Inf, -Inf, -Inf, -Inf, -Inf, -Inf, 10, 2),
nrow = 3, ncol = 3, byrow = TRUE)

b <- matrix(data = c(-Inf, -Inf, 3, -Inf, 0.5, -Inf, 1.1, -Inf, -Inf),
nrow = 3, ncol = 3, byrow = TRUE)

tropicalsparse.mul(a, b, 'coo', 'maxplus')

#      [,1] [,2] [,3]
# [1,] -Inf -Inf    8
# [2,] -Inf -Inf -Inf
# [3,]  3.1 10.5 -Inf

# also

a <- matrix(data = c(2, Inf, Inf, 0, Inf, Inf, Inf, 2, Inf),
nrow = 3, ncol = 3, byrow = TRUE)

b <- c(Inf, 0, 10)

tropicalsparse.mul(a, b, algebraType = 'minplus')

#      [,1] [,2] [,3]
# [1,]  Inf  Inf  Inf
# [2,]    0  Inf  Inf
# [3,]  Inf   12  Inf

}
\seealso{
\code{\link{tropicalsparse.add}}, \code{\link{tropicalsparse.storage}}
}
