% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{troopdata_rebuild_long}
\alias{troopdata_rebuild_long}
\title{U.S. overseas troop deployment data}
\format{
A data frame with country year observations including the following variables:

\describe{
\item{\code{ccode}}{A numeric vector of Correlates of War country codes.}
\item{\code{iso3c}}{A character vector of ISO three character country codes.}
\item{\code{countryname}}{A character vector of country names.}
\item{\code{region}}{Correlates of War geographic region name.}
\item{\code{year}}{The year of the observation.}
\item{\code{month}}{The month of the observation.}
\item{\code{quarter}}{The quarter of the observation.}
\item{\code{source}}{The DMDC report source of the observation.}
\item{\code{troops_ad}}{The total number of active duty US military personnel deployed to the host country.}
\item{\code{army_ad}}{Total number of active duty Army personnel deployed to the host country.}
\item{\code{navy_ad}}{Total number of active duty Navy personnel deployed to the host country.}
\item{\code{air_force_ad}}{Total number of active duty Air Force personnel deployed to the host country.}
\item{\code{space_force_ad}}{Total number of active duty Space Force personnel deployed to the host country.}
\item{\code{marine_corps_ad}}{Total number of Marine Corps personnel deployed to the host country.}
\item{\code{coast_guard_ad}}{Total number of Coast Guard personnel deployed to the host country.}
\item{\code{total_selected_reserve}}{Total number of reserve US military personnel deployed to the host country.}
\item{\code{army_reserve}}{Total number of reserve Army personnel deployed to the host country.}
\item{\code{navy_reserve}}{Total number of reserve Navy personnel deployed to the host country.}
\item{\code{air_force_reserve}}{Total number of reserve Air Force personnel deployed to the host country.}
\item{\code{marine_corps_reserve}}{Total number of reserve Marine Corps personnel deployed to the host country.}
\item{\code{coast_guard_reserve}}{Total number of reserve Coast Guard personnel deployed to the host country.}
\item{\code{army_national_guard}}{Total number of Army National Guard personnel deployed to the host country.}
\item{\code{air_national_guard}}{Total number of Air National Guard personnel deployed to the host country.}
\item{\code{army_civilian}}{Total number of Army civilian personnel deployed to the host country.}
\item{\code{navy_civilian}}{Total number of Navy civilian personnel deployed to the host country.}
\item{\code{air_force_civilian}}{Total number of Air Force civilian personnel deployed to the host country.}
\item{\code{marine_corps_civilian}}{Total number of Marine Corps civilian personnel deployed to the host country.}
\item{\code{dod_civilian}}{Total number of Department of Defense civilian personnel deployed to the host country.}
\item{\code{total_civilian}}{Total number of civilian personnel deployed to the host country.}
}
}
\source{
\url{https://www.heritage.org/defense/report/global-us-troop-deployment-1950-2005}

\doi{10.1177/07388942211030885}
}
\usage{
troopdata_rebuild_long
}
\value{
Returns the full data frame containing observations of US military deployments to overseas locations (countries and territories) from 1950 through 2024.
}
\description{
\code{troopdata} returns a data frame containing information on US military deployments.
}
\keyword{datasets}
