\name{pick}
\alias{pick}
\alias{picksegs}

\title{Choose twilight segments interactively from light data. }
\description{
 \code{pick} plots up series of light data agains record ID, allowing the user to click on the
 beginnings and ends of twilight in sequence. \code{picksegs} generates a vector
 of segment IDs for each record. 
}
\usage{
pick(id, val, nsee = 10000) 

picksegs(twind, n)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  %% pick
  \item{id}{index vector to identify records}
  \item{val}{ sequence of data (light levels) to choose segments from}
  \item{nsee}{ number of points to plot per screen }
  
  %% picksegs
  \item{twind}{ vector of index pairs generated by \code{pick}}
  \item{n}{Number of segments values required - length of record}
}
\details{
 Choosing twilight segments interactively seems far easier than trying to automate it.
 Mark Hindell makes the point that you get to see the data in detail, which is good. 
}
\value{
  \code{pick} returns a vector where each value (obtained using \code{\link{locator}} 
  is the x coordinate for the begin or end of a twilight. 
  
  \code{picksegs} uses these paired indexes to return a vector of segment IDs, with NAs
  for non-twilight periods. 
}
\references{ }
\author{ Michael D. Sumner }
\note{ It seems best to choose more of the light data than less, using the 
\code{ekstrom} keyword to \code{\link{solar.model}} we can limit the solar 
elevation used. 

 \section{Warning }{Segments are expected to be chosen as non-overlapping. } 
}
\seealso{  }
\examples{
\dontrun{
 
 d <- sin(seq(0, 10, by = 0.01))
 id <- 1:length(d)
 ## choose a series of start-begin pairs
 pk <- pick(id, d, 1000)
 ## your start/ends should be marked as blue versus red
 plot(id, d, col = c("red", "blue")[is.na(picksegs(pk, 1000))+1])
 
 }
}
\keyword{manip}
\keyword{dplot}
