% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coerce.R
\name{as.Other}
\alias{as.Other}
\alias{as.ppp.trip}
\alias{as.psp.trip}
\alias{explode}
\title{As ("trip", other-classes)}
\usage{
\method{as.ppp}{trip}(X, ..., fatal)

\method{as.psp}{trip}(x, ..., from, to)

explode(x, ...)
}
\arguments{
\item{X}{\code{trip} object.}

\item{...}{reserved for future methods}

\item{fatal}{Logical value, see Details of \code{\link[spatstat]{as.ppp}}}

\item{x}{\code{trip} object}

\item{from}{see \code{\link[spatstat]{as.psp}} for that method.}

\item{to}{See \code{\link[spatstat]{as.psp}}.}
}
\value{
ppp object

psp object

SpatialLinesDataFrame

SpatialLinesDataFrame object with each individual line segment identified by start/end time and trip ID
}
\description{
Coercing \code{trip} objects to other classes.

Function to create a SpatialLinesDataFrame from a trip object, resulting in
a line segment for each implicit segment along the tracks. The object stores
the start and end times, duration and the ID of the segment.
}
\examples{
\dontrun{
  ## Continuing the example from '?trip-methods:
utils::example("trip-methods", package="trip",
           ask=FALSE, echo=FALSE)
 as(tr, "ppp")
}
\dontrun{
 ## Continuing the example from '?trip-methods:
utils::example("trip-methods", package="trip",
           ask=FALSE, echo=FALSE)
 as.psp.trip(tr)
}
## Continuing the example from '?trip-methods:
utils::example("trip-methods", package="trip",
           ask=FALSE, echo=FALSE)
spldf <- explode(tr)
summary(tr)
}

