% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_psPwRbhmb.R
\name{psPwRbhmb}
\alias{psPwRbhmb}
\title{Powers of testing the primary and secondary hypotheses}
\usage{
psPwRbhmb(
  alpha,
  alpha0,
  t0,
  t1,
  tc0 = t0,
  tc1 = t1,
  rho = 0,
  iuse0 = 1,
  iuse1 = 1,
  phi0 = rep(1, length(alpha)),
  phi1 = rep(1, length(alpha)),
  usingRhoForBoundary = FALSE,
  groupsize,
  szratio = 1,
  effsz0,
  effsz1,
  method = "bonferroni"
)
}
\arguments{
\item{alpha}{a number shows the overall error rate}

\item{alpha0}{a number shows the error rate assigned to the primary endpoint initially}

\item{t0}{a vector shows the information times of the primary endpoint}

\item{t1}{a vector shows the information times of the secondary endpoint}

\item{tc0}{a vector shows the calendar times of the primary endpoint}

\item{tc1}{a vector shows the calendar times of the secondary endpoint}

\item{rho}{a number shows the correlation between the primary and secondary endpoints}

\item{iuse0}{an integer shows the type of group sequential boundaries used for the primary endpoint}

\item{iuse1}{an integer shows the type of group sequential boundaries used for the secondary endpoint}

\item{phi0}{a parameter for the power family or the HSD gamma family for the primary endpoint}

\item{phi1}{a parameter for the power family or the HSD gamma family for the secondary endpoint}

\item{usingRhoForBoundary}{an indicator whether using the informaiton of rho to calculate the boundary, default is FALSE (not using)}

\item{groupsize}{a value of sample size in group 1}

\item{szratio}{a value of the sample size ratio, n2/n1}

\item{effsz0}{a value of effect size for hypothesis H0}

\item{effsz1}{a value of effect size for hypothesis H1}

\item{method}{a text of method, including \code{holm}, \code{maurer-bretz}, \code{bonferroni}}
}
\value{
a vector of two values of the probability that H0 is rejected,  the probability that H1 is rejected, the power, using \code{holm}, \code{maurer-bretz}, or \code{bonferroni}.
}
\description{
This function computes the powers of testing the primary and secondary hypotheses using the \code{holm}, \code{maurer-bretz}, \code{bonferroni} methods.
}
\details{
The methods include \code{holm}, \code{maurer-bretz}, and \code{bonferroni}. Users can decide whether the correlation information is used or not.
}
\examples{
alpha <-  0.025
alpha0 <- 0.0136
iuse0 <- 1
iuse1 <- 2
phi0 <- -4
phi1 <- 1
tc0 <- c(1,2)
tc1 <- c(1,2,3)
t0 <- c(0.6,1)
t1 <- c(0.5,0.9,1)
rho <- 0
effsz0 <- 0.33 
effsz1 <- 0.30
groupsize=226
szratio=1
method="bonferroni"
method = "holm"
method="maurer-bretz"
psPwRbhmb(alpha=alpha, alpha0=alpha0, 
    t0=t0, t1=t1, tc0=tc0, tc1=tc1, 
    rho=rho, iuse0=1, iuse1=iuse1, 
    phi0=phi0, phi1=phi1, 
    usingRhoForBoundary=usingRhoForBoundary, 
    groupsize=groupsize, szratio=szratio, 
    effsz0=effsz0, effsz1=effsz1, 
    method=method) 
}
\references{
Gou, J. (2021). Trigger strategy in repeated tests on multiple hypotheses. Technical report.
}
\author{
Jiangtao Gou
}
