% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{map2_cog}
\alias{map2_cog}
\alias{pmap_cog}
\title{Map over multiple inputs simultaneously and return a vector of cognostics data frames}
\usage{
map2_cog(.x, .y, .f, ...)

pmap_cog(.l, .f, ...)
}
\arguments{
\item{.x, .y}{Vectors of the same length. A vector of length 1 will be recycled.}

\item{.f}{A function, formula, or atomic vector (see \code{\link[purrr]{map2}} for details)}

\item{...}{additional arguments passed on to .f.}

\item{.l}{A list of lists. The length of .l determines the number of arguments that .f will be called with. List names will be used if present.}
}
\description{
Map over multiple inputs simultaneously and return a vector of cognostics data frames
}
\details{
See \code{\link[purrr]{map2}}
}
\examples{
\donttest{
library(tidyr)
library(purrr)
library(rbokeh)
library(dplyr)

iris \%>\%
  nest(-Species) \%>\%
  mutate(
    mod = map(data, ~ lm(Sepal.Length ~ Sepal.Width, data = .x)),
    cogs = map2_cog(data, mod, function(data, mod) {
      tibble(max_sl = max(data$Sepal.Length), slope = coef(mod)[2])
    }),
    panel = map2_plot(data, mod, function(data, mod) {
      figure(xlab = "Sepal.Width", ylab = "Sepal.Length") \%>\%
        ly_points(data$Sepal.Width, data$Sepal.Length) \%>\%
        ly_abline(mod)
    })) \%>\%
  trelliscope(name = "iris")
}
}
