% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nds-methods.R
\name{getNdsLng}
\alias{getNdsLng}
\title{Get lineage for multiple nodes}
\usage{
getNdsLng(tree, ids, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Return unique taxonyms for connecting \code{ids} to root.
}
\details{
Returns a list, parallelizable.
}
\examples{
library(treeman)
data(mammals)
# return human and gorilla lineages
getNdsLng(mammals, id=c('Homo_sapiens', 'Gorilla_gorilla'))
}
\seealso{
\code{\link{getNdLng}}, \code{\link{getNdsFrmTxnyms}},
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
