% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot.transreg}
\alias{plot.transreg}
\title{Plot transreg-object}
\usage{
\method{plot}{transreg}(x, stack = NULL, ...)
}
\arguments{
\item{x}{object of type transreg}

\item{stack}{character "sta" (standard stacking) or "sim" (simultaneous stacking)}

\item{...}{(not applicable)}
}
\value{
Returns four plots.
\itemize{
\item top-left:
Calibrated prior effects (\eqn{y}-axis) against
original prior effects (\eqn{x}-axis).
Each line is for one source of prior effects,
with the colour given by \code{\link[grDevices:palette]{grDevices::palette()}}
(black: 1, red: 2, green: 3, blue: 4, ...).
\item top-right:
Estimated coefficients with transfer learning (\eqn{y}-axis)
against estimated coefficients without transfer learning (\eqn{x}-axis).
Each point represents one feature.
\item bottom-left:
Estimated weights for sources of prior effects
(labels 1 to \eqn{k}),
and either
estimated weights for \code{lambda.min} and \code{lambda.1se} models
(standard stacking)
or estimated weights for features
(simultaneous stacking).
\item bottom-right:
Absolute deviance residuals (\eqn{y}-axis)
against fitted values (\eqn{x}-axis).
Each point represents one sample.
}
}
\description{
Plot transreg-object
}
\examples{
#--- simulation ---
set.seed(1)
n <- 100; p <- 500
X <- matrix(rnorm(n=n*p),nrow=n,ncol=p)
beta <- rnorm(p) #*rbinom(n=n,size=1,prob=0.2)
prior1 <- beta + rnorm(p)
prior2 <- beta + rnorm(p)
prior3 <- rnorm(p)
prior4 <- rnorm(p)
y <- X \%*\% beta

prior <- cbind(prior1,prior2,prior3,prior4)
object <- transreg(y=y,X=X,prior=prior,alpha=0,stack=c("sta","sim"))

plot(object,stack="sta")

}
\references{
\href{https://orcid.org/0000-0001-6498-4801}{Armin Rauschenberger},
\href{https://orcid.org/0000-0002-2327-3904}{Zied Landoulsi},
\href{https://orcid.org/0000-0003-4780-8472}{Mark A. van de Wiel},
and
\href{https://orcid.org/0000-0003-3977-7469}{Enrico Glaab}
(2023).
"Penalised regression with multiple sets of prior effects".
\emph{Bioinformatics (In press).}
\doi{10.1093/bioinformatics/btad680}
\email{armin.rauschenberger@uni.lu}
}
\seealso{
Methods for objects of class \link{transreg}
include \code{\link[=coef.transreg]{coef}}
and \code{\link[=predict.transreg]{predict}}.
}
