% Generated by roxygen2 (4.0.0): do not edit by hand
\name{cont.inf.model}
\alias{cont.inf.model}
\alias{cont.inf.model-class}
\title{Continuous Time Infectious Disease Modeling on Individuals}
\arguments{
\item{df}{an event formatted data.frame.}

\item{patients}{an data frame of patient information with admission, discharge
and optionally infection times}

\item{tests}{an data frame of test information with test time, patient id, and result.}
}
\description{
Continuous Time Infectious Disease Modeling on Individuals
}
\section{Fields}{

\describe{
\item{\code{run(n)}}{run the mcmc chain for n steps.}

\item{\code{runll(n)}}{run the mcmc chain for n steps with returning the log likelihood included.}

\item{\code{load}}{<- by <- events(df) load data by events}

\item{\code{load(patients,}}{tests)    load by patients and tests as separate data frames.}

\item{\code{load_by_list(list)}}{load data with a list containing patient and test data frames.}

\item{\code{events}}{Retrieve a list of the events}

\item{\code{nEvents}}{Number of events}

\item{\code{nPatients}}{Number of patients}

\item{\code{using_slope}}{are we using a slope model or not.}

\item{\code{transmission}}{The transmission parameter}

\item{\code{importation}}{The probability of a patient entering infected.}

\item{\code{false.neg}}{The probability of a test being a false negative.}

\item{\code{false.pos}}{The probability of a test being a false positive.}

\item{\code{logLik}}{The log Likelihood}

\item{\code{nPatients}}{The number of patients in the population}

\item{\code{nSamples}}{The number of Samples}

\item{\code{doStates}}{Take a step updating states}

\item{\code{doTransmission}}{Take a transmission update step}

\item{\code{doImportation}}{Take an importation update step}

\item{\code{doFN}}{Take a false negative update step}

\item{\code{doFP}}{Take a false positive update step}

\item{\code{doSlope}}{Take a slope update step.}
}}
\seealso{
\code{\link{doSim}} for simulating data.

Other mcmc: \code{\link{tmMCMC}}
}

