\name{computePatientDays}
\alias{computePatientDays}
\alias{countInfections}
\title{Compute metrics on simulated disease transmission data.}
\usage{
  computePatientDays(patients)

  countInfections(patients)
}
\arguments{
  \item{patients}{the full patient info data.frame

  the patients days and patient days at risk}
}
\value{
  a vector of patients days, and patients days at risk.
}
\description{
  Compute metrics on simulated disease transmission data.

  Count infections
}
\details{
  The patient days are computed as the sum of the time
  patients are in the hospital The patient days at risk are
  computed as the sum of the time patients are uninfected.
  Patients who are poistive upon admission do not add
  anything to the patient days at risk Patients who aqcuire
  in the hospital add the time from admission to infect to
  the patient days at risk.

  The \code{patients} data.frame must have the columns
  \enumerate{ \item pid the patient id \item admit the
  admission time \item discharge the discharge time \item
  infection the infection time: missing is never infected,
  equal to admit implies importation, and anything else is
  the actual infection time and must be between admit and
  discharge.  } This format is the exact same that is the
  result from \code{\link{doSim}} for \code{$patients}.
}

