% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeStrings.R
\name{computeChar_rindex}
\alias{computeChar_rindex}
\title{Locate position of last occurence of a pattern}
\usage{
computeChar_rindex (x,pattern = NULL, split = 0)
}
\arguments{
\item{x}{atomic character or character vector.}

\item{pattern}{atomic character to look for.}

\item{split}{numeric. Number of parts pattern to divide to.}
}
\value{
Numeric. Position of the last occurence of the \code{pattern}
}
\description{
Helper Function for xpssCompute. R Implementation of the SPSS \code{CHAR.RINDEX} Function.
}
\details{
\code{computeChar_index(x="Hello user", pattern="user")} Returns a number indicating the character position of the last occurrence of the first letter of 'user' in 'Hello user'. The optional third argument, \code{split}, is a number, which must be a positive integer used to divide 'user' into separate strings. The \code{split} value must be able to divide the \code{pattern} string without remainder.
}
\examples{
xpssCompute(x="At the end i'm looking for a good end", fun="computeChar_rindex", pattern="end")
}
\author{
Bastian Wiessner
}
\seealso{
\code{\link{str_locate_all}}
}
\keyword{internal}

