% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xpssComputeStrings.R
\name{computeChar_index}
\alias{computeChar_index}
\title{Locate position of first occurence of a pattern}
\usage{
computeChar_index (x,pattern = NULL, split = 0)
}
\arguments{
\item{x}{atomic character or character vector.}

\item{pattern}{atomic character to look for.}

\item{split}{atomic numeric. Number of parts pattern to divide to.}
}
\value{
Numeric. Position of the first occurence of the \code{pattern}.
}
\description{
Helper Function for xpssCompute. R Implementation of the SPSS \code{CHAR.INDEX} Function.
}
\details{
\code{computeChar_index(x="Hello user", pattern="user")} Returns a number indicating the character position of the first occurrence of the first letter of 'user' in 'Hello user'. The optional third argument, \code{split}, is a number, which must be a positive integer used to divide 'user' into separate strings. The \code{split} value must be able to divide the \code{pattern} string without remainder.
}
\examples{
xpssCompute(x="there is no letter in word", fun="computeChar_index", pattern="letter")

xpssCompute(x="there is no letter in word", fun="computeChar_index", pattern="string")

xpssCompute(x=c("fruits are sweet", "fruits are sour","fruits are salty"),
fun="computeChar_index", pattern="sweet")
}
\author{
Bastian Wiessner
}
\seealso{
\code{\link{str_locate_all}}
}
\keyword{internal}

