% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kin.2d.R
\name{wave}
\alias{wave}
\title{Compute wavelengths from a sine-like waveform}
\usage{
wave(
  x,
  y,
  method = "zeros",
  zero.begin = TRUE,
  fit = TRUE,
  dens = 10,
  smooth = 0.1,
  smoothing = "loess"
)
}
\arguments{
\item{x}{numeric; x position}

\item{y}{numeric; y position}

\item{method}{character; how waves should be found and classified, where it crosses zero/the internodal length ("zeros"), peak to peak ("p2p") or trough to trough ("t2t"). See Details.}

\item{zero.begin}{logical; does wave begin at zero? Default is 'TRUE' and will help find waves beginning at first x,y values if y=0}

\item{fit}{logical; if 'method="zeros"', should zeros be detected by a fitting operation. See Details.}

\item{dens}{numeric; factor by which to increase the sample density used in fitting when 'method="zeros"'. See Details.}

\item{smooth}{numeric; if \code{smoothing} is set to 'loess', 'span' parameter value for \code{\link{loess}}. If \code{smoothing} is set to 'spline' 'spar' parameter value for \code{\link{smooth.spline}}}

\item{smoothing}{character; the smoothing method when 'fit=TRUE', either 'loess' or 'spline'. See Details.}
}
\value{
A list with the following components:

\code{method} the method chosen to find full waves

 \code{names} a data table with columns 'x', 'y', and 'wave' describing the x and y positions of the wave and a numeric name of each wave detected, respectively. If  'method="zeros"' and 'fit=TRUE', these values reflect the predicted, more dense data as determined by \code{smoothing}, \code{smooth}, and \code{dens}.
 
\code{dat} a data table describing each wave detected.
\itemize{
\item 'zeros': x value where y crosses zero. Returns NA if \code{method} is 'p2p' or 't2t', value is NA.
\item 'wave.begin': x value where each wave begins.
\item 'wave.end': x value where each wave ends.
\item 'begin.index': x index of where each wave begins.
\item 'end.index': x index of where each  wave ends.
\item 'wave': numeric name of each wave.
\item 'l': the length of each  wave.
\item 'amp1': the peak amplitude of each wave. If method is set to 'p2p' or 't2t' this is the begin amplitude. If "method='zeros'" this is the peak amplitude between internodes. 
\item 'amp2': If method is set to 'p2p' or 't2t' this is the end amplitude. If "method='zeros'" this is the minimum amplitude between internodes. 
\item 'pos1': If method is set to 'p2p' or 't2t' the x position of begin amplitude for each half wave and identical to 'begin'. If "method='zeros'", the position of peak amplitude between the internodes. 
\item 'pos2': If method is set to 'p2p' or 't2t' the x position of end amplitude for each half wave and identical to 'end'. If "method='zeros'", the position of minimum amplitude between the internodes.
}

If  'method="zeros"' and 'fit=TRUE', these values reflect the predicted, more dense data as determined by \code{smoothing},\code{smooth}, and \code{dens}.
}
\description{
Computes full wavelengths and their positions and amplitude from a sine-like waveform based on either peak-to-peak, trough-to-trough, or internodal distance.
}
\details{
If 'method="p2p"' or 'method="t2t"', full waves are found using critical points (i.e., local maxima, the peaks or minima, the troughs) with \code{\link{features}}.

If 'method="zeros"' and 'fit=TRUE', zero crossings are determined by first increasing the sample density by a factor determined by \code{dens}. A more dense \code{\link{loess}} or \code{\link{smooth.spline}} model is then fit to the data and new y values predicted. Wave positions and lengths are determined based on these predicted values. This option should be useful when the sampling density of the waveform is relatively low and therefor detected wave positions and zero crossings (the internodes) may be rather coarse.
}
\examples{

require(ggplot2)
#Find length of the full waves
x <- seq(0,pi,0.01)
y <- sin(x^2*pi)

#zero method
w.z <- wave(x,y,method="zeros",smoothing="spline",smooth=0.1)

#plot wave with detected full waves using fitted 'zeros' method
p <- ggplot()+geom_point(aes(x=x,y=y))
p <- p+geom_line(data=w.z$names,aes(x=x,y=y,col=wave),alpha=0.4,size=3,inherit.aes=FALSE)
p+theme_classic()

#plot lambda as it varies with position

qplot(data=w.z$dat,x=pos1,y=l)

#trough-to-trough method
w.p <- wave(x,y,method="t2t")

qplot(data=w.p$names,x=x,y=y,col=wave)

}
\seealso{
\code{\link{features}}, \code{\link{loess}}, \code{\link{smooth.spline}}
}
