% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnFunctions.R
\name{manuallySelect}
\alias{manuallySelect}
\title{Manually identify true and false positives with a GUI.}
\usage{
manuallySelect(particles, colorimages = NULL, frame = NULL)
}
\arguments{
\item{particles}{A data frame of class 'TrDm' with particle statistics for each frame,
obtained by \code{\link{identifyParticles}}.}

\item{colorimages}{An array with the original full color images, in order to plot
on the original images. If \code{NULL}, the original color images are used, obtained
 from the global environment.}

\item{frame}{A number defining the frame that should be used. Default
is \code{NULL}; in that case the frame with the maximum number of identified particles is used.}
}
\value{
List containing three elements: true positives, false positives,
and the evaluated frame.
}
\description{
\code{manuallySelect} opens a graphic user iterface to create
 training data for a neural net by manually selecting true and
 false positives (respectively, correctly identified particles and noise).
}
\examples{
\dontrun{
manuallySelect(particles=partIden,frame=1)
}
}
\author{
Marjolein Bruijning, Caspar A. Hallmann & Marco D. Visser
}
