% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tcpl_based.R
\name{summary_tcpl}
\alias{summary_tcpl}
\title{function to summarize curve fitting results}
\usage{
summary_tcpl(tcpl_models, spid_chnm_table = NULL)
}
\arguments{
\item{tcpl_models}{the list object returned by 'fit_curve_tcpl' function}

\item{spid_chnm_table}{a reference table with 'spid' and the corresponding chemical name 'chnm' column,
and the CAS number 'casn' column.}
}
\value{
a data.frame contains summarized metrics for each chemical (spid)
}
\description{
function to summarize curve fitting results
}
\examples{
## supply models as the essential argument. spid_chnm_table is optional.
demo_md <- fit_curve_tcpl(mc_norm, assay_info =
list(prim_assay = "Primary", toxi_assay = "Cytotox"))
demo_sum <- summary_tcpl(demo_md)


## start from raw data
# define assay
assay_info <- list(prim_assay = "Primary",toxi_assay = "Cytotox")
# data normalization
demo_mc_norm <- normalize_per_plate(demo_mc, nctrl = "DMSO")
# filter out two test chemicals
demo_mc_norm <- dplyr::filter(demo_mc_norm, spid \%in\% c("TP0001502B05", "TP0001502B01"))
# fit curve with default 20\% threshold
demo_md <- fit_curve_tcpl(demo_mc_norm, assay_info)
# obtain summary table
demo_sum <- summary_tcpl(demo_md)

}
