% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_gnls_funcs.R
\name{gnls_curve}
\alias{gnls_curve}
\title{Gain Loss Curve.}
\usage{
gnls_curve(top, ga, gw, la, lw, lconc)
}
\arguments{
\item{top}{Numeric, gnls top parameter.}

\item{ga}{Numeric, gnls gain AC50 parameter.}

\item{gw}{Numeric, gnls gain coefficient parameter.}

\item{la}{Numeric, gnls loss AC50 parameter.}

\item{lw}{Numeric, gnls loss coefficient parameter.}

\item{lconc}{Numeric, concentration (in log uM) to calculate the response.}
}
\value{
y Numeric, the calculated response value at lconc.
}
\description{
\code{gnls_curve} is used calculate response values given gnls parameters.
}
\details{
Given input values for the gnls parameters and a concentration, this function
returns the response value at the given concentration. Used to plot the gnls
equation resulting from a given fit.
}
\examples{
gnls_curve(top = 100, ga = 0.5, gw = 1, la = 1.5, lw = 8, lconc = 0)
}
