% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effectplot.R
\name{get_snpset}
\alias{get_snpset}
\title{Create a dataframe that can be used as input for making effect plots}
\usage{
get_snpset(
  df1,
  df2,
  thresh = 5e-08,
  protein_coding_only = TRUE,
  region_size = 1e+06,
  verbose = NULL,
  show_full_output = FALSE,
  build = 38
)
}
\arguments{
\item{df1}{The dataframe to extract the top snps from (with p-value below thresh)}

\item{df2}{The dataframe in which to search for overlapping SNPs from dataframe1}

\item{thresh}{A number. P-value threshold, only extract variants with p-values below this threshold (5e-08 by default)}

\item{protein_coding_only}{Logical, set this variable to TRUE to only use protein_coding genes for annotation}

\item{region_size}{An integer (default = 20000000) (or a string represented as 200kb or 2MB) indicating the window size for variant labeling. Increase this number for sparser annotation and decrease for denser annotation.}

\item{verbose}{Logical, (default: FALSE). Assign to TRUE to get information on which alleles are matched and which are not.}

\item{show_full_output}{A logical scalar (default:FALSE). Assign to TRUE to show the full output from this function}

\item{build}{A string, genome build, choose between builds 37 (GRCh37) and 38 (GRCh38) (default is 38)}
}
\value{
Dataframe of overlapping snps (snpset)
}
\description{
\code{get_snpset()}
}
\examples{
\dontrun{
CD_UKBB_index_snps <-get_lead_snps(CD_UKBB)
get_snpset(CD_UKBB_index_snps, CD_FINNGEN)
}

}
