% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regionplot.R
\name{regionplot}
\alias{regionplot}
\title{Create a regionplot}
\usage{
regionplot(
  df,
  ntop = 3,
  annotate = NULL,
  xmin = 0,
  size = 2,
  shape = 19,
  alpha = 1,
  label_size = 4,
  annotate_with = "ID",
  color = get_topr_colors(),
  axis_text_size = 11,
  axis_title_size = 12,
  title_text_size = 13,
  show_genes = FALSE,
  show_overview = TRUE,
  show_exons = FALSE,
  max_genes = 200,
  sign_thresh = 5e-09,
  sign_thresh_color = "red",
  sign_thresh_label_size = 3.5,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  protein_coding_only = FALSE,
  region_size = 1e+06,
  gene_padding = 1e+05,
  angle = 0,
  legend_title_size = 12,
  legend_text_size = 11,
  nudge_x = 0.01,
  nudge_y = 0.01,
  rsids = NULL,
  variant = NULL,
  rsids_color = NULL,
  legend_name = "",
  legend_position = "right",
  chr = NULL,
  vline = NULL,
  show_gene_names = NULL,
  legend_labels = NULL,
  gene = NULL,
  title = NULL,
  label_color = NULL,
  locuszoomplot = FALSE,
  region = NULL,
  legend_nrow = NULL,
  gene_label_size = NULL,
  scale = 1,
  show_legend = TRUE,
  sign_thresh_linetype = "dashed",
  sign_thresh_size = 0.5,
  rsids_with_vline = NULL,
  annotate_with_vline = NULL,
  show_gene_legend = TRUE,
  unit_main = 7,
  unit_gene = 2,
  unit_overview = 1.25,
  verbose = TRUE
)
}
\arguments{
\item{df}{Dataframe or a list of dataframes (required columns are \code{CHROM,POS,P}), in upper- or lowercase) of association results.}

\item{ntop}{An integer, number of datasets (GWAS results) to show on the top plot}

\item{annotate}{A number (p-value). Display annotation for variants with p-values below this threshold}

\item{xmin}{Integer, setting the chromosomal range to display on the x-axis}

\item{size}{An integer setting the size of the plot points (default: \code{size=1.2})}

\item{shape}{A number of vector of numbers setting the shape of the plotted points}

\item{alpha}{A number or vector of numbers setting the transparency of the plotted points}

\item{label_size}{An number to set the size of the plot labels (default: \code{label_size=3})}

\item{annotate_with}{A string. Annotate the variants with either Gene_Symbol or ID (default: "Gene_Symbol")}

\item{color}{A string or a vector of strings, for setting the color of the datapoints on the plot}

\item{axis_text_size}{A number, size of the x and y axes tick labels (default: 12)}

\item{axis_title_size}{A number, size of the x and y title labels (default: 12)}

\item{title_text_size}{A number, size of the plot title (default: 13)}

\item{show_genes}{A logical scalar, show genes instead of exons (default show_genes=FALSE)}

\item{show_overview}{A logical scalar, shows/hides the overview plot (default= TRUE)}

\item{show_exons}{A logical scalar, show exons instead of genes (default show_exons=FALSE)}

\item{max_genes}{An integer, only label the genes if they are fewer than max_genes (default values is 200).}

\item{sign_thresh}{A number or vector of numbers, setting the horizontal significance threshold (default: \code{sign_thresh=5.1e-9}). Set to NULL to hide the significance threshold.}

\item{sign_thresh_color}{A string or vector of strings to set the color/s of the significance threshold/s}

\item{sign_thresh_label_size}{A number setting the text size of the label for the signficance thresholds (default text size is 3.5)}

\item{xmax}{Integer, setting the chromosomal range to display on the x-axis}

\item{ymin}{Integer, min and max of the y-axis, (default values: \code{ymin=0, ymax=max(-log10(df$P))})}

\item{ymax}{Integer, min and max of the y-axis, (default values: \code{ymin=0, ymax=max(-log10(df$P))})}

\item{protein_coding_only}{A logical scalar, if TRUE, only protein coding genes are used for annotation}

\item{region_size}{An integer (default = 1000000) indicating the window size for variant labelling. Increase this number for sparser annotation and decrease for denser annotation.}

\item{gene_padding}{An integer representing size of the region around the gene, if the gene argument was used (default = 100000)}

\item{angle}{A number, the angle of the text label}

\item{legend_title_size}{A number, size of the legend title}

\item{legend_text_size}{A number, size of the legend text}

\item{nudge_x}{A number to vertically adjust the starting position of each gene label (this is a ggrepel parameter)}

\item{nudge_y}{A number to horizontally adjust the starting position of each gene label (this is a ggrepel parameter)}

\item{rsids}{A string (rsid) or vector of strings to highlight on the plot, e.g. \code{rsids=c("rs1234, rs45898")}}

\item{variant}{A string representing the variant to zoom in on. Can be either an rsid, or a dataframe (with the columns CHROM,POS,P)}

\item{rsids_color}{A string, the color of the variants in variants_id (default color is red)}

\item{legend_name}{A string, use to change the name of the legend (default: None)}

\item{legend_position}{A string, top,bottom,left or right}

\item{chr}{A string or integer, the chromosome to plot (i.e. chr15), only required if the input dataframe contains results from more than one chromosome}

\item{vline}{A number or vector of numbers to add a vertical line to the plot at a specific chromosomal position, e.g \code{vline=204000066}. Multiple values can be provided in a vector, e.g  \code{vline=c(204000066,100500188)}}

\item{show_gene_names}{A logical scalar, if set to TRUE, gene names are shown even though they exceed the max_genes count}

\item{legend_labels}{A string or vector of strings representing legend labels for the input dataset/s}

\item{gene}{A string representing the gene to zoom in on (e.g. gene=FTO)}

\item{title}{A string}

\item{label_color}{A string. To change the color of the gene or variant labels}

\item{locuszoomplot}{A logical scalar set to FALSE. Only set to TRUE by calling the locuszoom function}

\item{region}{A string representing a genetic region, e.g. chr1:67038906-67359979}

\item{legend_nrow}{An integer, sets the number of rows allowed for the legend labels}

\item{gene_label_size}{A number setting the size of the gene labels shown at the bottom of the plot}

\item{scale}{A number, to change the size of the title and axes labels and ticks at the same time (default = 1)}

\item{show_legend}{A logical scalar, set to FALSE to hide the legend (default value is TRUE)}

\item{sign_thresh_linetype}{A string, the linetype of the horizontal significance threshold (default = dashed)}

\item{sign_thresh_size}{A number, sets the size of the horizontal significance threshold line (default = 1)}

\item{rsids_with_vline}{A string (rsid) or vector of strings to highlight on the plot with their rsids and vertical lines further highlighting their positions}

\item{annotate_with_vline}{A number (p-value). Display annotation and vertical lines for variants with p-values below this threshold}

\item{show_gene_legend}{A logical scalar, set to FALSE to hide the gene legend (default value is TRUE)}

\item{unit_main}{the height unit of the main plot (default = 7)}

\item{unit_gene}{the height unit of the gene plot (default= 2 )}

\item{unit_overview}{the height unit of the overview plot (default = 1.25)}

\item{verbose}{Logical, set to FALSE to get suppress printed information}
}
\value{
plots within ggplotGrobs, arranged with egg::gtable_frame
}
\description{
\code{regionplot()} displays the association results for a smaller genetic regions within one chromosome.
Required parameter is at least one dataset (dataframe) containing the association data (with columns \code{CHROM,POS,P} in upper or lowercase) and either a variant ID, gene name or the genetic region represented as a chromosome together with start and stop positions (either as a single string or as three separate arguments).

All other input parameters are optional
}
\examples{
regionplot(CD_UKBB, gene="IL23R")
}
