% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pruning.R
\name{pruning_details}
\alias{pruning_details}
\alias{pruning_details.tna}
\alias{pruning_details.group_tna}
\title{Print Detailed Information on the Pruning Results}
\usage{
pruning_details(x, ...)

\method{pruning_details}{tna}(x, ...)

\method{pruning_details}{group_tna}(x, ...)
}
\arguments{
\item{x}{A \code{tna} or \code{group_tna} object.}

\item{...}{Ignored.}
}
\value{
A \code{data.frame} containing the removed edges if \code{x} is a \code{tna} object,
or a \code{list} of \code{data.frame} objects in the case of \code{group_tna} object.
}
\description{
Print Detailed Information on the Pruning Results
}
\examples{
model <- tna(group_regulation)
pruned_threshold <- prune(model, method = "threshold", threshold = 0.1)
pruning_details(pruned_threshold)

}
\seealso{
Evaluation and validation functions
\code{\link{bootstrap}()},
\code{\link{permutation_test}()},
\code{\link{prune}()}

Cluster-related functions
\code{\link{bootstrap}()},
\code{\link{centralities}()},
\code{\link{cliques}()},
\code{\link{communities}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{group_model}()},
\code{\link{hist.group_tna}()},
\code{\link{mmm_stats}()},
\code{\link{plot.group_tna}()},
\code{\link{plot.group_tna_centralities}()},
\code{\link{plot.group_tna_cliques}()},
\code{\link{plot.group_tna_communities}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot_compare.group_tna}()},
\code{\link{plot_mosaic.group_tna}()},
\code{\link{plot_mosaic.tna_data}()},
\code{\link{print.group_tna}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_centralities}()},
\code{\link{print.group_tna_cliques}()},
\code{\link{print.group_tna_communities}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{prune}()},
\code{\link{rename_groups}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna}()},
\code{\link{summary.group_tna_bootstrap}()}
}
\concept{clusters}
\concept{evaluation}
