% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.tna}
\alias{summary.tna}
\title{Calculate Summary of Network Metrics for a Transition Network}
\usage{
\method{summary}{tna}(object, ...)
}
\arguments{
\item{object}{A \code{tna} object.}

\item{...}{Ignored}
}
\value{
A named \code{list} containing the following network metrics (invisibly):
\itemize{
\item \code{node_count}: The total number of nodes.
\item \code{edge_count}: The total number of edges.
\item \code{network_Density}: The density of the network.
\item \code{mean_distance}: The mean shortest path length.
\item \code{mean_out_strength}: The mean out-strength of nodes.
\item \code{sd_out_strength}: The standard deviation of out-strength.
\item \code{mean_in_strength}: The mean in-strength of nodes.
\item \code{sd_in_strength}: The standard deviation of in-strength.
\item \code{mean_out_degree}: The mean out-degree of nodes.
\item \code{sd_out_degree}: The standard deviation of out-degree.
\item \code{centralization_out_degree}: The centralization of out-degree.
\item \code{centralization_in_degree}: The centralization of in-degree.
\item \code{reciprocity}: The reciprocity of the network.
}
}
\description{
This function calculates a variety of network metrics for a \code{tna} object.
It computes key metrics such as node and edge counts, network density,
mean distance, strength measures, degree centrality, and reciprocity.
}
\details{
The function extracts the \code{igraph} network  and
computes the following network metrics:
\itemize{
\item Node count: Total number of nodes in the network.
\item Edge count: Total number of edges in the network.
\item Network density: Proportion of possible edges that
are present in the network.
\item Mean distance: The average shortest path length between nodes.
\item Mean and standard deviation of out-strength and in-strength: Measures
of the total weight of outgoing and incoming edges for each node.
\item Mean and standard deviation of out-degree: The number of outgoing
edges from each node.
\item Centralization of out-degree and in-degree: Measures of how
centralized the network is based on the degrees of nodes.
\item Reciprocity: The proportion of edges that are reciprocated
(i.e., mutual edges between nodes).
}

A summary of the metrics is printed to the console.
}
\examples{
model <- tna(engagement)
summary(model)

}
