% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blocking-evaluations.R
\name{confusion.from.blocking}
\alias{confusion.from.blocking}
\title{Perform evaluations (recall) for blocking.}
\usage{
confusion.from.blocking(blocking, true_ids, recall.only = FALSE)
}
\arguments{
\item{blocking}{A list of the blocks}

\item{true_ids}{The true identifiers for comparisons}

\item{recall.only}{Flag that when true only prints the recall, otherwise
prints many evaluation metrics in a list}
}
\value{
A vector of that returns the recall and the precision
}
\description{
Perform evaluations (recall) for blocking.
}
\examples{
r.set <- RLdata500[1:250,c(-2)]
tlsh.blocks <- block_setup_v2(r.set, b=22, save_signature=FALSE, k=2)
confusion.from.blocking(tlsh.blocks, identity.RLdata500, recall.only=TRUE)
}
