% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.Rcpp_tlars_cpp.R
\name{plot.Rcpp_tlars_cpp}
\alias{plot.Rcpp_tlars_cpp}
\title{Plots the T-LARS solution path}
\usage{
\method{plot}{Rcpp_tlars_cpp}(
  x,
  xlab = "# Included dummies",
  ylab = "Coefficients",
  include_dummies = TRUE,
  actions = TRUE,
  col_selected = "black",
  col_dummies = "red",
  lty_selected = "solid",
  lty_dummies = "dashed",
  legend_pos = "topleft",
  ...
)
}
\arguments{
\item{x}{Object of the class tlars_cpp. See \link{tlars_cpp} for details.}

\item{xlab}{Label of the x-axis.}

\item{ylab}{Label of the y-axis.}

\item{include_dummies}{Logical. If TRUE solution paths of dummies are added to the plot.}

\item{actions}{Logical. If TRUE axis above plot with indices of added variables
(Dummies represented by 'D') along the solution path is added.}

\item{col_selected}{Color of lines corresponding to selected variables.}

\item{col_dummies}{Color of lines corresponding to included dummies.}

\item{lty_selected}{Line type of lines corresponding to selected variables.
See \link{par} for more details.}

\item{lty_dummies}{Line type of lines corresponding to included dummies.
See \link{par} for more details.}

\item{legend_pos}{Legend position. See \link{xy.coords} for more details.}

\item{...}{Ignored. Only added to keep structure of generic \link{plot} function.}
}
\value{
Plots the T-LARS solution path stored in C++ objects of class tlars_cpp (no plot for type = "lasso").
}
\description{
Plots the T-LARS solution path stored in C++ objects of class tlars_cpp
(see \link{tlars_cpp} for details) if the object is created with type = "lar"
(no plot for type = "lasso").
}
\examples{
data("Gauss_data")
X <- Gauss_data$X
y <- drop(Gauss_data$y)
p <- ncol(X)
n <- nrow(X)
num_dummies <- p
dummies <- matrix(stats::rnorm(n * p), nrow = n, ncol = num_dummies)
XD <- cbind(X, dummies)
mod_tlars <- tlars_model(X = XD, y = y, num_dummies = num_dummies)
tlars(model = mod_tlars, T_stop = 3, early_stop = TRUE)
plot(mod_tlars)
}
\seealso{
\link{tlars_cpp}, \link{plot}, \link{par}, and \link{xy.coords}.
}
