% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{tkLocator}
\alias{tkLocator}
\title{Gives the Position}
\usage{
tkLocator(parent, n = 1)
}
\arguments{
\item{parent}{Tk toplevel window}

\item{n}{the number of points to locate}
}
\value{
A list with x and y components which are the coordinates of the identified points.
}
\description{
Gives the position when the left mouse button is pressed + "Ctrl" button.
}
\examples{
\dontrun{
bb <- 1
tt <- tktoplevel()
tt <- tkRplot(tt, function() {
 x <- 1:20 / 20
   plot(
   x,
   x ^ bb,
   col = "#0000ff50",
       xlab = "x",
           ylab = paste0("x^", bb),
               type = "l",
                   axes = FALSE,
                       lwd = 4)
   title(main = bb)
     points(x,
      x ^ bb,
      col = "#ff000050",
      pch = 19,
      cex = 2)
        axis(1)
        axis(2)
          box()
          })
 tkLocator(tt, 2)
 }

}
