% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_snapshot_plot.R
\name{expect_equivalent_images}
\alias{expect_equivalent_images}
\title{Test if two image files are equivalent}
\usage{
expect_equivalent_images(
  current,
  target,
  tol = getOption("tinysnapshot_tol", default = 0),
  metric = getOption("tinysnapshot_metric", default = "AE"),
  fuzz = getOption("tinysnapshot_fuzz", default = 0),
  style = getOption("tinysnapshot_plot_diff_style", default = c("old", "new", "diff")),
  review = getOption("tinysnapshot_plot_review", default = TRUE),
  diffpath = NULL
)
}
\arguments{
\item{current}{path to an image file}

\item{target}{path to an image file}

\item{tol}{distance estimates larger than this threshold will trigger a test failure. Scale depends on the \code{metric} argument. With the default \code{metric="AE"} (absolute error), the \code{tolerance} corresponds roughly to the number of pixels of difference between the plot and the reference image.}

\item{metric}{string with a metric from \code{magick::metric_types()} such as \code{"AE"} or \code{"phash"}.}

\item{fuzz}{relative color distance between 0 and 100 to be considered similar.}

\item{style}{A character vector to control the panels of the diff image saved to file. The order and number of entries controls the side-by-side panels. Allowable values are: "old", "new", "diff".}

\item{review}{logical. TRUE if a a diff plot should be saved to file for review when the expectation fails.}

\item{diffpath}{path where to save an image which shows the differences between \code{current} and \code{target}. \code{NULL} means that the diff image is not saved.}
}
\value{
A \code{tinytest} object. A \code{tinytest} object is a \code{logical} with attributes holding information about the test that was run
}
\description{
Test if two image files are equivalent
}
