% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type_lines.R
\name{type_lines}
\alias{type_lines}
\title{Lines plot type}
\usage{
type_lines(type = "l")
}
\arguments{
\item{type}{1-character string giving the type of plot desired.  The
    following values are possible, for details, see \code{\link[graphics]{plot}}:
    \code{"p"} for points, \code{"l"} for lines,
    \code{"b"} for both points and lines,
    \code{"c"} for empty points joined by lines,
    \code{"o"} for overplotted points and lines,
    \code{"s"} and \code{"S"} for stair steps and
    \code{"h"} for histogram-like vertical lines.  Finally,
    \code{"n"} does not produce any points or lines.}
}
\description{
Type function for plotting lines.
}
\examples{
# "l" type convenience character string
tinyplot(circumference ~ age | Tree, data = Orange, type = "l")

# Use `type_lines()` to pass extra arguments for customization
tinyplot(circumference ~ age | Tree, data = Orange, type = type_lines(type = "s"))

}
