% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/targetRank.R
\name{targetRank}
\alias{targetRank}
\title{Generate the list of ranked target combinations}
\usage{
targetRank(profile_select, predicted_matrix)
}
\arguments{
\item{profile_select}{the drug-target interaction profile for the selected targets}

\item{predicted_matrix}{the predicted efficacy matrix}
}
\value{
a matrix containing the list of target combinations
}
\description{
A function to provide a list of target combiantions ranked by their predicted synergy scores
}
\examples{
\dontrun{
data(tyner_interaction_binary)
data(tyner_sensitivity)
float<-sffsBinary(tyner_interaction_binary, tyner_sensitivity[, 1], max_k = 8)
k_select<-float$k_sel
x<-data.frame(tyner_interaction_binary)
kinase_names <- dimnames(x)[[2]]
select_kinase_names <- findSameSet(x, k_select, kinase_names)
gc_timma <- graycode3(length(k_select))
gc_names <- graycodeNames(length(k_select), select_kinase_names, gc_timma$gc_row, gc_timma$gc_col)
nr <- gc_names$nr
nc <- t(gc_names$nc)
timma_row <- nrow(nr) + nrow(nc)
timma_col <- ncol(nr) + ncol(nc)
timma <- array("", dim = c(timma_row, timma_col))
timma[(nrow(nc) + 1):timma_row, 1:ncol(nr)] <- nr
timma[1:nrow(nc), (ncol(nr) + 1):timma_col] <- nc
timma[(nrow(nc) + 1):timma_row, (ncol(nr) + 1):timma_col] <- float$timma$dummy
profile_select<-data.frame(tyner_interaction_binary)[, k_select]
target_combo_rank<-targetRank(profile_select, timma)
}
}
\author{
Jing Tang \email{jing.tang@helsinki.fi}
}
\references{
Tang J, Karhinen L, Xu T, Szwajda A, Yadav B, Wennerberg K, Aittokallio T.
Target inhibition networks: predicting selective combinations of druggable targets to block cancer
survival pathways. PLOS Computational Biology 2013; 9: e1003226.
}

