% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-seasonal_diagnostics.R
\name{plot_seasonal_diagnostics}
\alias{plot_seasonal_diagnostics}
\title{Visualize Multiple Seasonality Features for One or More Time Series}
\usage{
plot_seasonal_diagnostics(
  .data,
  .date_var,
  .value,
  .facet_vars = NULL,
  .feature_set = "auto",
  .geom = c("boxplot", "violin"),
  .geom_color = "#2c3e50",
  .geom_outlier_color = "#2c3e50",
  .title = "Seasonal Diagnostics",
  .x_lab = "",
  .y_lab = "",
  .interactive = TRUE
)
}
\arguments{
\item{.data}{A \code{tibble} or \code{data.frame} with a time-based column}

\item{.date_var}{A column containing either date or date-time values}

\item{.value}{A column containing numeric values}

\item{.facet_vars}{One or more grouping columns that broken out into \code{ggplot2} facets.
These can be selected using \code{tidyselect()} helpers (e.g \code{contains()}).}

\item{.feature_set}{One or multiple selections to analyze for seasonality. Choices include:
\itemize{
\item "auto" - Automatically selects features based on the time stamps and length of the series.
\item "second" - Good for analyzing seasonality by second of each minute.
\item "minute" - Good for analyzing seasonality by minute of the hour
\item "hour" - Good for analyzing seasonality by hour of the day
\item "wday.lbl" - Labeled weekdays. Good for analyzing seasonality by day of the week.
\item "week" - Good for analyzing seasonality by week of the year.
\item "month.lbl" - Labeled months. Good for analyzing seasonality by month of the year.
\item "quarter" - Good for analyzing seasonality by quarter of the year
\item "year" - Good for analyzing seasonality over multiple years.
}}

\item{.geom}{Either "boxplot" or "violin"}

\item{.geom_color}{Geometry color. Line color.
Use keyword: "scale_color" to change the color by the facet.}

\item{.geom_outlier_color}{Color used to highlight outliers.}

\item{.title}{Plot title.}

\item{.x_lab}{Plot x-axis label}

\item{.y_lab}{Plot y-axis label}

\item{.interactive}{If TRUE, returns a \code{plotly} interactive plot.
If FALSE, returns a static \code{ggplot2} plot.}
}
\value{
A \code{plotly} or \code{ggplot2} visualization
}
\description{
An interactive and scalable function for visualizing time series seasonality.
Plots are available in interactive \code{plotly} (default) and static \code{ggplot2} format.
}
\details{
\strong{Automatic Feature Selection}

Internal calculations are performed to detect a sub-range of features to include
useing the following logic:
\itemize{
\item The \emph{minimum} feature is selected based on the median difference between consecutive
timestamps
\item The \emph{maximum} feature is selected based on having 2 full periods.
}

Example: Hourly timestamp data that lasts more than 2 weeks will have the following features:
"hour", "wday.lbl", and "week".

\strong{Scalable with Grouped Data Frames}

This function respects grouped \code{data.frame} and \code{tibbles} that were made with \code{dplyr::group_by()}.

For grouped data, the automatic feature selection returned is a collection of all
features within the sub-groups. This means extra features are returned even though
they may be meaningless for some of the groups.

\strong{Transformations}

The \code{.value} parameter respects transformations (e.g. \code{.value = log(sales)}).
}
\examples{
\donttest{
library(dplyr)
library(timetk)

# ---- MULTIPLE FREQUENCY ----
# Taylor 30-minute dataset from forecast package
taylor_30_min

# Visualize series
taylor_30_min \%>\%
    plot_time_series(date, value, .interactive = FALSE)

# Visualize seasonality
taylor_30_min \%>\%
    plot_seasonal_diagnostics(date, value, .interactive = FALSE)

# ---- GROUPED EXAMPLES ----
# m4 hourly dataset
m4_hourly

# Visualize series
m4_hourly \%>\%
    group_by(id) \%>\%
    plot_time_series(date, value, .facet_scales = "free", .interactive = FALSE)

# Visualize seasonality
m4_hourly \%>\%
    group_by(id) \%>\%
    plot_seasonal_diagnostics(date, value, .interactive = FALSE)

}

}
