% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augment-tk_augment_timeseries.R
\name{tk_augment_timeseries}
\alias{tk_augment_timeseries}
\alias{tk_augment_timeseries_signature}
\title{Add many time series features to the data}
\usage{
tk_augment_timeseries_signature(.data, .date_var = NULL)
}
\arguments{
\item{.data}{A time-based tibble or time-series object.}

\item{.date_var}{For \code{tibbles}, a column containing either date or date-time values.
If \code{NULL}, the time-based column will interpret from the object (tibble, xts, zoo, etc).}
}
\value{
Returns a \code{tibble} object describing the timeseries.
}
\description{
Add many time series features to the data
}
\details{
\code{tk_augment_timeseries_signature()} adds 25+ time series features including:
\itemize{
\item \strong{Trend in Seconds Granularity:} index.num
\item \strong{Yearly Seasonality:} Year, Month, Quarter
\item \strong{Weekly Seasonality:} Week of Month, Day of Month, Day of Week, and more
\item \strong{Daily Seasonality:} Hour, Minute, Second
\item \strong{Weekly Cyclic Patterns:} 2 weeks, 3 weeks, 4 weeks
}
}
\examples{
library(dplyr)
library(timetk)

m4_daily \%>\%
    group_by(id) \%>\%
    tk_augment_timeseries_signature(date)

}
\seealso{
Augment Operations:
\itemize{
\item \code{\link[=tk_augment_timeseries_signature]{tk_augment_timeseries_signature()}} - Group-wise augmentation of timestamp features
\item \code{\link[=tk_augment_holiday_signature]{tk_augment_holiday_signature()}} - Group-wise augmentation of holiday features
\item \code{\link[=tk_augment_roll_apply]{tk_augment_roll_apply()}} - Group-wise augmentation of rolling functions
\item \code{\link[=tk_augment_lags]{tk_augment_lags()}} - Group-wise augmentation of lagged data
\item \code{\link[=tk_augment_differences]{tk_augment_differences()}} - Group-wise augmentation of differenced data
\item \code{\link[=tk_augment_fourier]{tk_augment_fourier()}} - Group-wise augmentation of fourier series
}

Underlying Function:
\itemize{
\item \code{\link[=tk_get_timeseries_signature]{tk_get_timeseries_signature()}} - Returns timeseries features from an index
}
}
