% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-pc-hazard.r
\name{sim.cox}
\alias{sim.cox}
\alias{read.fit}
\alias{sim.base}
\title{Simulation of output from Cox model.}
\usage{
\method{sim}{cox}(cox, n, data = NULL, cens = NULL, rrc = NULL, entry = NULL, ...)
}
\arguments{
\item{cox}{output form coxph or cox.aalen model fitting cox model.}

\item{n}{number of simulations.}

\item{data}{to extract covariates for simulations (draws from observed
covariates).}

\item{cens}{specifies censoring model, if "is.matrix" then uses cumulative
hazard given, if "is.scalar" then uses rate for exponential, and if not
given then takes average rate of in simulated data from cox model.}

\item{rrc}{possible vector of relative risk for cox-type censoring.}

\item{entry}{delayed entry variable for simulation.}

\item{...}{arguments for rchaz, for example entry-time}
}
\description{
Simulates data that looks like fit from Cox model. Censor data automatically
for highest value of the event times by using cumulative hazard.
}
\examples{

data(TRACE)
cox <-  coxph(Surv(time,status==9)~vf+chf+wmi,data=TRACE)
sim1 <- sim.cox(cox,1000,data=TRACE)
cc <- coxph(Surv(time,status)~vf+chf+wmi,data=sim1)
cbind(cox$coef,cc$coef)

cor(sim1[,c("vf","chf","wmi")])
cor(TRACE[,c("vf","chf","wmi")])

\donttest{
### do not test to avoid dependence on mets
library(mets)
cox <-  phreg(Surv(time, status==9)~vf+chf+wmi,data=TRACE)
sim3 <- sim.cox(cox,1000,data=TRACE)
cc <-  phreg(Surv(time, status)~vf+chf+wmi,data=sim3)
cbind(cox$coef,cc$coef)
basehazplot.phreg(cox,se=TRUE)
lines(cc$cumhaz,col=2)

cox <-  phreg(Surv(time,status==9)~strata(chf)+vf+wmi,data=TRACE)
sim3 <- sim.cox(cox,1000,data=TRACE)
cc <-   phreg(Surv(time, status)~strata(chf)+vf+wmi,data=sim3)
cbind(cox$coef,cc$coef)
basehazplot.phreg(cox)
basehazplot.phreg(cc,add=TRUE)
}

}
\author{
Thomas Scheike
}
\keyword{survival}
