% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_expand.R
\name{time_expand}
\alias{time_expand}
\alias{time_complete}
\title{A time based extension to \code{tidyr::complete()}.}
\usage{
time_expand(
  data,
  time = NULL,
  ...,
  .by = NULL,
  time_by = NULL,
  from = NULL,
  to = NULL,
  sort = TRUE
)

time_complete(
  data,
  time = NULL,
  ...,
  .by = NULL,
  time_by = NULL,
  from = NULL,
  to = NULL,
  sort = TRUE,
  fill = NA
)
}
\arguments{
\item{data}{A data frame.}

\item{time}{Time variable.}

\item{...}{Groups to expand.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{time_by}{A \link{timespan}.}

\item{from}{Time series start date.}

\item{to}{Time series end date.}

\item{sort}{Logical. If \code{TRUE} expanded/completed variables are sorted.}

\item{fill}{A named list containing value-name pairs to fill the named implicit missing values.}
}
\value{
A \code{data.frame} of expanded time by or across groups.
}
\description{
A time based extension to \code{tidyr::complete()}.
}
\details{
This works much the same as \code{tidyr::complete()}, except that
you can supply an additional \code{time} argument to allow for
completing implicit time gaps and creating time sequences by group.
}
\examples{
library(timeplyr)
library(dplyr)
library(lubridate)
library(nycflights13)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
x <- flights$time_hour

time_num_gaps(x) # Missing hours

flights_count <- flights \%>\%
  fastplyr::f_count(time_hour)

# Fill in missing hours
flights_count \%>\%
  time_complete(time = time_hour)

# You can specify units too
flights_count \%>\%
  time_complete(time = time_hour, time_by = "hours")
flights_count \%>\%
  time_complete(time = as_date(time_hour), time_by = "days") #  Nothing to complete here

# Where time_expand() and time_complete() really shine is how fast they are with groups
flights \%>\%
  group_by(origin, dest) \%>\%
  time_expand(time = time_hour, time_by = dweeks(1))
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
