% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roll_apply.R
\name{roll_apply}
\alias{roll_apply}
\title{By-group rolling functions}
\usage{
roll_apply(
  x,
  fun,
  before = Inf,
  after = 0L,
  g = NULL,
  partial = TRUE,
  unlist = FALSE
)
}
\arguments{
\item{x}{Numeric vector, data frame, or list.}

\item{fun}{A function.}

\item{before}{A number denoting how many indices
to look backward on a rolling basis.}

\item{after}{A number denoting how many indices to look forward on a rolling
basis.}

\item{g}{Grouping object passed directly to \code{collapse::GRP()}.
This can for example be a vector or data frame.}

\item{partial}{Should calculations be done using partial windows?
Default is \code{TRUE}.}

\item{unlist}{If \code{TRUE}, the result is passed to \code{unlist()}.
The default is \code{FALSE}.}
}
\value{
\code{roll_apply} returns a list the same length as \code{x} unless \code{unlist} is \code{TRUE}.
}
\description{
Apply any function on a rolling basis
for each group using one-pass through the data.
}
\details{
\code{roll_apply} accepts any user function which makes it more flexible
than the other rolling functions but much less efficient.
}
\seealso{
\link{time_roll_apply} \link{roll_sum} \link{roll_growth_rate}
}
