\name{holidayDate}


\title{Public and Ecclesiastical Holidays}


\alias{holidayDate}

\alias{Septuagesima}
\alias{Quinquagesima}
\alias{AshWednesday}
\alias{PalmSunday}
\alias{GoodFriday}
\alias{EasterSunday}
\alias{EasterMonday}
\alias{RogationSunday}
\alias{Ascension}
\alias{Pentecost}
\alias{PentecostMonday}
\alias{TrinitySunday}
\alias{CorpusChristi}
\alias{ChristTheKing}
\alias{Advent1st}
\alias{Advent2nd}
\alias{Advent3rd}
\alias{Advent4th}
\alias{ChristmasEve}
\alias{ChristmasDay}
\alias{BoxingDay}
\alias{NewYearsDay}
\alias{SolemnityOfMary}
\alias{Epiphany}
\alias{PresentationOfLord}
\alias{Annunciation}
\alias{TransfigurationOfLord}
\alias{AssumptionOfMary}
\alias{BirthOfVirginMary}
\alias{CelebrationOfHolyCross}
\alias{MassOfArchangels}
\alias{AllSaints}
\alias{AllSouls}
\alias{LaborDay}
\alias{CHBerchtoldsDay}
\alias{CHSechselaeuten}
\alias{CHAscension}
\alias{CHConfederationDay}
\alias{CHKnabenschiessen}
\alias{GBMayDay}
\alias{GBBankHoliday}
\alias{GBSummerBankHoliday}
\alias{GBMilleniumDay}
\alias{DEAscension}
\alias{DECorpusChristi}
\alias{DEGermanUnity}
\alias{DEChristmasEve}
\alias{DENewYearsEve}
\alias{FRFetDeLaVictoire1945}
\alias{FRAscension}
\alias{FRBastilleDay}
\alias{FRAssumptionVirginMary}
\alias{FRAllSaints}
\alias{FRArmisticeDay}
\alias{ITEpiphany}
\alias{ITLiberationDay}
\alias{ITAssumptionOfVirginMary}
\alias{ITAllSaints}
\alias{ITStAmrose}
\alias{ITImmaculateConception}
\alias{USDecorationMemorialDay}
\alias{USPresidentsDay}
\alias{USNewYearsDay}
\alias{USInaugurationDay}
\alias{USMLKingsBirthday}
\alias{USLincolnsBirthday}
\alias{USWashingtonsBirthday}
\alias{USMemorialDay}
\alias{USIndependenceDay}
\alias{USLaborDay}
\alias{USColumbusDay}
\alias{USElectionDay}
\alias{USVeteransDay}
\alias{USThanksgivingDay}
\alias{USChristmasDay}
\alias{USCPulaskisBirthday}
\alias{USGoodFriday}
\alias{USJuneteenthNationalIndependenceDay}
\alias{CAVictoriaDay}
\alias{CAFamilyDay}
\alias{CACanadaDay}
\alias{CACivicProvincialHoliday}
\alias{CALabourDay}
\alias{CAThanksgivingDay}
\alias{CaRemembranceDay}
\alias{JPVernalEquinox}
\alias{JPNewYearsDay}
\alias{JPGantan}
\alias{JPBankHolidayJan2}
\alias{JPBankHolidayJan3}
\alias{JPComingOfAgeDay}
\alias{JPSeijinNoHi}
\alias{JPNatFoundationDay}
\alias{JPKenkokuKinenNoHi}
\alias{JPGreeneryDay}
\alias{JPMidoriNoHi}
\alias{JPConstitutionDay}
\alias{JPKenpouKinenBi}
\alias{JPNationHoliday}
\alias{JPKokuminNoKyujitu}
\alias{JPChildrensDay}
\alias{JPKodomoNoHi}
\alias{JPMarineDay}
\alias{JPUmiNoHi}
\alias{JPRespectForTheAgedDay}
\alias{JPKeirouNOhi}
\alias{JPAutumnalEquinox}
\alias{JPShuubunNoHi}
\alias{JPHealthandSportsDay}
\alias{JPTaiikuNoHi}
\alias{JPNationalCultureDay}
\alias{JPBunkaNoHi}
\alias{JPThanksgivingDay}
\alias{JPKinrouKanshaNoHi}
\alias{JPEmperorsBirthday}
\alias{JPTennouTanjyouBi}
\alias{JPBankHolidayDec31}


\description{

    A collection and description of functions and methods
    dealing with holiday dates in the G7 countries and
    Switzerland.
    \cr

}


\usage{
Septuagesima(year = getRmetricsOptions("currentYear"))
Quinquagesima(year = getRmetricsOptions("currentYear"))
AshWednesday(year = getRmetricsOptions("currentYear"))
PalmSunday(year = getRmetricsOptions("currentYear"))
GoodFriday(year = getRmetricsOptions("currentYear"))
EasterSunday(year = getRmetricsOptions("currentYear"))
EasterMonday(year = getRmetricsOptions("currentYear"))
RogationSunday(year = getRmetricsOptions("currentYear"))
Ascension(year = getRmetricsOptions("currentYear"))
Pentecost(year = getRmetricsOptions("currentYear"))
PentecostMonday(year = getRmetricsOptions("currentYear"))
TrinitySunday(year = getRmetricsOptions("currentYear"))
CorpusChristi(year = getRmetricsOptions("currentYear"))
ChristTheKing(year = getRmetricsOptions("currentYear"))
Advent1st(year = getRmetricsOptions("currentYear"))
Advent2nd(year = getRmetricsOptions("currentYear"))
Advent3rd(year = getRmetricsOptions("currentYear"))
Advent4th(year = getRmetricsOptions("currentYear"))
ChristmasEve(year = getRmetricsOptions("currentYear"))
ChristmasDay(year = getRmetricsOptions("currentYear"))
BoxingDay(year = getRmetricsOptions("currentYear"))
NewYearsDay(year = getRmetricsOptions("currentYear"))
SolemnityOfMary(year = getRmetricsOptions("currentYear"))
Epiphany(year = getRmetricsOptions("currentYear"))
PresentationOfLord(year = getRmetricsOptions("currentYear"))
Annunciation(year = getRmetricsOptions("currentYear"))
TransfigurationOfLord(year = getRmetricsOptions("currentYear"))
AssumptionOfMary(year = getRmetricsOptions("currentYear"))
BirthOfVirginMary(year = getRmetricsOptions("currentYear"))
CelebrationOfHolyCross(year = getRmetricsOptions("currentYear"))
MassOfArchangels(year = getRmetricsOptions("currentYear"))
AllSaints(year = getRmetricsOptions("currentYear"))
AllSouls(year = getRmetricsOptions("currentYear"))
LaborDay(year = getRmetricsOptions("currentYear"))
CHBerchtoldsDay(year = getRmetricsOptions("currentYear"))
CHSechselaeuten(year = getRmetricsOptions("currentYear"))
CHAscension(year = getRmetricsOptions("currentYear"))
CHConfederationDay(year = getRmetricsOptions("currentYear"))
CHKnabenschiessen(year = getRmetricsOptions("currentYear"))
GBMayDay(year = getRmetricsOptions("currentYear"))
GBBankHoliday(year = getRmetricsOptions("currentYear")) # see note in details section
GBSummerBankHoliday(year = getRmetricsOptions("currentYear"))
GBMilleniumDay(year = getRmetricsOptions("currentYear"))
DEAscension(year = getRmetricsOptions("currentYear"))
DECorpusChristi(year = getRmetricsOptions("currentYear"))
DEGermanUnity(year = getRmetricsOptions("currentYear"))
DEChristmasEve(year = getRmetricsOptions("currentYear"))
DENewYearsEve(year = getRmetricsOptions("currentYear"))
FRFetDeLaVictoire1945(year = getRmetricsOptions("currentYear"))
FRAscension(year = getRmetricsOptions("currentYear"))
FRBastilleDay(year = getRmetricsOptions("currentYear"))
FRAssumptionVirginMary(year = getRmetricsOptions("currentYear"))
FRAllSaints(year = getRmetricsOptions("currentYear"))
FRArmisticeDay(year = getRmetricsOptions("currentYear"))
ITEpiphany(year = getRmetricsOptions("currentYear"))
ITLiberationDay(year = getRmetricsOptions("currentYear"))
ITAssumptionOfVirginMary(year = getRmetricsOptions("currentYear"))
ITAllSaints(year = getRmetricsOptions("currentYear"))
ITStAmrose(year = getRmetricsOptions("currentYear"))
ITImmaculateConception(year = getRmetricsOptions("currentYear"))
USDecorationMemorialDay(year = getRmetricsOptions("currentYear"))
USPresidentsDay(year = getRmetricsOptions("currentYear"))
USNewYearsDay(year = getRmetricsOptions("currentYear"))
USInaugurationDay(year = getRmetricsOptions("currentYear"))
USMLKingsBirthday(year = getRmetricsOptions("currentYear"))
USLincolnsBirthday(year = getRmetricsOptions("currentYear"))
USWashingtonsBirthday(year = getRmetricsOptions("currentYear"))
USMemorialDay(year = getRmetricsOptions("currentYear"))
USIndependenceDay(year = getRmetricsOptions("currentYear"))
USLaborDay(year = getRmetricsOptions("currentYear"))
USColumbusDay(year = getRmetricsOptions("currentYear"))
USElectionDay(year = getRmetricsOptions("currentYear"))
USVeteransDay(year = getRmetricsOptions("currentYear"))
USThanksgivingDay(year = getRmetricsOptions("currentYear"))
USChristmasDay(year = getRmetricsOptions("currentYear"))
USCPulaskisBirthday(year = getRmetricsOptions("currentYear"))
USGoodFriday(year = getRmetricsOptions("currentYear"))
USJuneteenthNationalIndependenceDay(year = getRmetricsOptions("currentYear"))
CAVictoriaDay(year = getRmetricsOptions("currentYear"))
CACanadaDay(year = getRmetricsOptions("currentYear"))
CACivicProvincialHoliday(year = getRmetricsOptions("currentYear"))
CALabourDay(year = getRmetricsOptions("currentYear"))
CAThanksgivingDay(year = getRmetricsOptions("currentYear"))
CaRemembranceDay(year = getRmetricsOptions("currentYear"))
JPVernalEquinox (year = getRmetricsOptions("currentYear"))
JPNewYearsDay(year = getRmetricsOptions("currentYear"))
JPGantan(year = getRmetricsOptions("currentYear"))
JPBankHolidayJan2(year = getRmetricsOptions("currentYear"))
JPBankHolidayJan3(year = getRmetricsOptions("currentYear"))
JPComingOfAgeDay(year = getRmetricsOptions("currentYear"))
JPSeijinNoHi(year = getRmetricsOptions("currentYear"))
JPNatFoundationDay(year = getRmetricsOptions("currentYear"))
JPKenkokuKinenNoHi(year = getRmetricsOptions("currentYear"))
JPGreeneryDay(year = getRmetricsOptions("currentYear"))
JPMidoriNoHi(year = getRmetricsOptions("currentYear"))
JPConstitutionDay(year = getRmetricsOptions("currentYear"))
JPKenpouKinenBi(year = getRmetricsOptions("currentYear"))
JPNationHoliday(year = getRmetricsOptions("currentYear"))
JPKokuminNoKyujitu(year = getRmetricsOptions("currentYear"))
JPChildrensDay(year = getRmetricsOptions("currentYear"))
JPKodomoNoHi(year = getRmetricsOptions("currentYear"))
JPMarineDay(year = getRmetricsOptions("currentYear"))
JPUmiNoHi(year = getRmetricsOptions("currentYear"))
JPRespectForTheAgedDay(year = getRmetricsOptions("currentYear"))
JPKeirouNOhi(year = getRmetricsOptions("currentYear"))
JPAutumnalEquinox(year = getRmetricsOptions("currentYear"))
JPShuubunNoHi(year = getRmetricsOptions("currentYear"))
JPHealthandSportsDay(year = getRmetricsOptions("currentYear"))
JPTaiikuNoHi(year = getRmetricsOptions("currentYear"))
JPNationalCultureDay(year = getRmetricsOptions("currentYear"))
JPBunkaNoHi(year = getRmetricsOptions("currentYear"))
JPThanksgivingDay(year = getRmetricsOptions("currentYear"))
JPKinrouKanshaNoHi(year = getRmetricsOptions("currentYear"))
JPEmperorsBirthday(year = getRmetricsOptions("currentYear"))
JPTennouTanjyouBi(year = getRmetricsOptions("currentYear"))
JPBankHolidayDec31(year = getRmetricsOptions("currentYear"))
}


\arguments{

    \item{year}{
        an integer value or vector of year numbers including the
        century. These are integers of the form \code{CCYY}, e.g.
        \code{2000}.
        }

}


\value{

    The function \code{listHolidays} returns a character vector
    with the names of the supported holidays.

    The holiday functions return an ISO-8601 formatted 'timeDate'
    of the requested holiday.

}

\details{
  Note that \code{GBBankHoliday()} returns GB Spring bank holiday. For GB holiday
  calender see \code{holidayGB()}.
}

\examples{
## listHolidays -
   listHolidays()

## CHSechselaeuten -
   # Sechselaeuten a half Day Bank Holiday in Switzerland
   CHSechselaeuten(2000:2010)
   CHSechselaeuten(getRmetricsOptions("currentYear"))

## German Unification Day:
   DEGermanUnity(getRmetricsOptions("currentYear"))
}


\keyword{chron}

