% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_save_dataset.R
\name{tt_save_dataset}
\alias{tt_save_dataset}
\title{Save datasets for submission}
\usage{
tt_save_dataset(
  dataset,
  path = "tt_submission",
  dataset_name = rlang::caller_arg(dataset),
  open = rlang::is_interactive(),
  ignore = FALSE
)
}
\arguments{
\item{dataset}{The clean dataset to save. The dataset must be a data.frame.}

\item{path}{The relative path to the directory to hold your submission files
(\code{tt_submission} by default). If this directory does not exist, it will be
created.}

\item{dataset_name}{The name to save the dataset as. By default, the name of
the dataset variable is used.}

\item{open}{Open the newly created file for editing? Happens in RStudio, if
applicable, or via \code{\link[utils:file.edit]{utils::file.edit()}} otherwise.}

\item{ignore}{Should the newly created file be added to \code{.Rbuildignore}?}
}
\value{
A logical vector indicating whether the file was created or
modified, invisibly.
}
\description{
Datasets for TidyTuesday submissions should be saved in a specific format,
with an accompanying data dictionary \code{dataset_name.md} file. This function
saves the dataset as a CSV file in your submission directory (creating the
submission directory if it does not already exist), and creates a data
dictionary file for you to fill out. If you're in an interactive session, the
dictionary file is opened for editing.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

  tt_save_dataset(mtcars)
\dontshow{\}) # examplesIf}
}
