% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_load.R, R/tt_load_gh.R, R/utils.R
\name{print.tt_data}
\alias{print.tt_data}
\alias{print.tt}
\alias{printing}
\title{print methods of the tt objects}
\usage{
\method{print}{tt_data}(x, ...)

\method{print}{tt}(x, ...)
}
\arguments{
\item{x}{a tt_data or tt object}

\item{...}{further arguments passed to or from other methods.}
}
\value{
used to show readme and list names of available datasets

\code{x}, invisibly.
}
\description{
In tidytuesdayR there are nice print methods for the objects that were used
to download and store the data from the TidyTuesday repo. They will always
print the available datasets/files. If there is a readme available,
it will try to display the TidyTuesday readme.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tt <- tt_load_gh("2019-01-15")
print(tt)

tt_data <- tt_download(tt, files = "All")
print(tt_data)
\dontshow{\}) # examplesIf}
}
