% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlang-like.R
\name{eval_unquoted}
\alias{eval_unquoted}
\title{Execute code after tidy evaluation}
\usage{
eval_unquoted(...)
}
\arguments{
\item{...}{R code snippets}
}
\value{
The value of the last evaluated expression.
}
\description{
This function takes R code as arguments and executes this code in the calling environment.
All quoted variables (using rlang's quasiquotation, !! or !!!) will be unquoted prior to evaluation.
This results in executed in code in which the variable is replaced verbatim by its value,
as if you had typed the variable's value.
This is particularly useful for functions using base R's substitute() approach, such
as functions taking formulas, and you have built the formula dynamically.
It is unnecessary for all functions based on tidy_eval (dplyr).
}
\examples{
library(rlang)
# Note that evaluation takes place in the calling environment!
l <- quo(l <- 1) # l is a quosure in our env
eval_unquoted(!!l)
l == 1 # TRUE: l is now a vector
}
