% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_na-Spat.R
\name{drop_na.SpatRaster}
\alias{drop_na.SpatRaster}
\title{Drop cells of SpatRaster objects containing missing values}
\usage{
\method{drop_na}{SpatRaster}(data, ...)
}
\arguments{
\item{data}{A SpatRaster created with \code{\link[terra:rast]{terra::rast()}}.}

\item{...}{\code{\link[tidyr:drop_na]{tidy-select}}  Layers to inspect
for missing values. If empty, all layers are used.}
}
\value{
A Spat* object  of the same class than \code{.data}. See \strong{Methods}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}. See \strong{Methods}.

\code{drop_na()} method drops cells where any layer specified by \code{...} contains
a missing value.
}
\section{Feedback needed!}{


Visit \url{https://github.com/dieghernan/tidyterra/issues}. The implementation
of this method for SpatRaster may change in the future.
}

\section{terra equivalent}{


\code{\link[terra:trim]{terra::trim()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[tidyr:drop_na]{tidyr::drop_na()}} function.
\subsection{SpatRaster}{

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}

Actual implementation of \verb{drop_na().SpatRaster} can be understood as a
masking method based on the values of the layers (see \code{\link[terra:mask]{terra::mask()}}).

Raster layers are considered as columns and raster cells as rows, so rows
(cells) with any \code{NA} value on any layer would get a \code{NA} value. It is
possible also to mask the cells (rows) based on the values of specific
layers (columns).

\code{drop_na()} would effectively remove outer cells that are \code{NA} (see
\code{\link[terra:trim]{terra::trim()}}), so the extent of the resulting object may differ of the
extent of the input (see \code{\link[terra:resample]{terra::resample()}} for more info).

Check the \strong{Examples} to have a better understanding of this method.
}
}

\examples{

library(terra)


r <- rast(
  crs = "EPSG:3857",
  extent = c(0, 10, 0, 10),
  nlyr = 3,
  resolution = c(2.5, 2.5)
)
terra::values(r) <- seq_len(ncell(r) * nlyr(r))



# Add NAs
r[r > 13 & r < 22 | r > 31 & r < 45] <- NA

# Init
plot(r, nc = 3)

# Mask with lyr.1
r \%>\%
  drop_na(lyr.1) \%>\%
  plot(nc = 3)

# Mask with lyr.2
r \%>\%
  drop_na(lyr.2) \%>\%
  plot(nc = 3)

# Mask with lyr.3
r \%>\%
  drop_na(lyr.3) \%>\%
  plot(nc = 3)

# Auto-mask all layers
r \%>\%
  drop_na() \%>\%
  plot(nc = 3)

}
\seealso{
\code{\link[tidyr:drop_na]{tidyr::drop_na()}}, \code{\link[=drop_na]{drop_na()}}.
}
\keyword{internal}
