% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_describe_data.r
\name{tidy_describe_data}
\alias{tidy_describe_data}
\title{Convert descriptives to a tidy data frame}
\usage{
tidy_describe_data(descriptives)
}
\arguments{
\item{descriptives}{A data frame created with tidystats' \code{describe_data}.}
}
\description{
\code{tidy_describe_data} returns a tidy data frame of descriptive statistics created with \strong{tidystats}' \code{describe_data}.
}
\examples{
library(dplyr)

# Calculate descriptives
descriptives <- describe_data(sleep, extra)

# Create a tidy data frame of the descriptives
tidy_describe_data(descriptives)

# With a grouping variable:
sleep \%>\%
  group_by(group) \%>\%
  describe_data(extra) \%>\%
  tidy_describe_data()

}
