% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_motifs.R
\name{find_motifs}
\alias{find_motifs}
\alias{find_motifs.sq}
\alias{find_motifs.data.frame}
\title{Find given motifs}
\usage{
find_motifs(x, ...)

\method{find_motifs}{sq}(x, name, motifs, ..., NA_letter = getOption("tidysq_NA_letter"))

\method{find_motifs}{data.frame}(
  x,
  motifs,
  ...,
  .sq = "sq",
  .name = "name",
  NA_letter = getOption("tidysq_NA_letter")
)
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{...}{further arguments to be passed from or to other methods.}

\item{name}{[\code{character}]\cr
Vector of sequence names. Must be of the same length as \code{sq} object.}

\item{motifs}{[\code{character}]\cr
Motifs to be searched for.}

\item{NA_letter}{[\code{character(1)}]\cr
A string that is used to interpret and display \code{NA} value in the
context of \code{\link[=sq-class]{sq class}}. Default value equals to
"\code{!}".}

\item{.sq}{[\code{character(1)}]\cr
Name of a column that stores sequences.}

\item{.name}{[\code{character(1)}]\cr
Name of a column that stores names (unique identifiers).}
}
\value{
A \code{\link[tibble]{tibble}} with following columns:
 \item{name}{name of the sequence in which a motif was found}
 \item{sought}{sought motif}
 \item{found}{found subsequence, may differ from sought if the motif
  contained ambiguous letters}
 \item{start}{position of first element of found motif}
 \item{end}{position of last element of found motif}
}
\description{
Finds all given motifs in sequences and returns their positions.
}
\details{
This function allows search of a given motif or motifs in the \code{sq}
object. It returns all motifs found with their start and end positions within
a sequence.
}
\section{Motif capabilities and restrictions}{

There are more options than to simply create a motif that is a string
representation of searched subsequence. For example, when using this function
with any of standard types, i.e. \strong{ami}, \strong{dna} or \strong{rna},
the user can create a motif with ambiguous letters. In this case the engine
will try to match any of possible meanings of this letter. For example, take
"B" from extended DNA alphabet. It means "not A", so it can be matched with
"C", "G" and "T", but also "B", "Y" (either "C" or "T"), "K" (either "G" or
"T") and "S" (either "C" or "G").

Full list of ambiguous letters with their meaning can be found on IUPAC site.

Motifs are also restricted in that the alphabets of \code{sq} objects on
which search operations are conducted cannot contain "^" and "$" symbols.
These two have a special meaning - they are used to indicate beginning and
end of sequence respectively and can be used to limit the position of matched
subsequences.
}

\examples{
# Creating objects to work on:
sq_dna <- sq(c("ATGCAGGA", "GACCGNBAACGAN", "TGACGAGCTTAG"),
             alphabet = "dna_bsc")
sq_ami <- sq(c("AGNTYIKFGGAYTI", "MATEGILIAADGYTWIL", "MIPADHICAANGIENAGIK"),
             alphabet = "ami_bsc")
sq_atp <- sq(c("mAmYmY", "nbAnsAmA", ""),
             alphabet = c("mA", "mY", "nbA", "nsA"))
sq_names <- c("sq1", "sq2", "sq3")

# Finding motif of two alanines followed by aspartic acid or asparagine
# ("AAB" motif matches "AAB", "AAD" and "AAN"):
find_motifs(sq_ami, sq_names, "AAB")

# Finding "C" at fourth position:
find_motifs(sq_dna, sq_names, "^NNNC")

# Finding motif "I" at second-to-last position:
find_motifs(sq_ami, sq_names, "IX$")

# Finding multiple motifs:
find_motifs(sq_dna, sq_names, c("^ABN", "ANCBY", "BAN$"))

# Finding multicharacter motifs:
find_motifs(sq_atp, sq_names, c("nsA", "mYmY$"))

# It can be a part of tidyverse pipeline:
library(dplyr)
fasta_file <- system.file(package = "tidysq", "examples/example_aa.fasta")
read_fasta(fasta_file) \%>\%
  mutate(name = toupper(name)) \%>\%
  find_motifs("TXG")

}
\seealso{
Functions interpreting sq in biological context:
\code{\link{\%has\%}()},
\code{\link{complement}()},
\code{\link{translate}()}
}
\concept{bio_functions}
