% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_sq.R
\name{export_sq}
\alias{export_sq}
\title{Export sq objects into other formats}
\usage{
export_sq(x, export_format, name = NULL, ...)
}
\arguments{
\item{x}{[\code{sq}]\cr
An object this function is applied to.}

\item{export_format}{[\code{character(1)}]\cr
A string indicating desired class (with specified package for clarity).}

\item{name}{[\code{character}]\cr
Vector of sequence names. Must be of the same length as \code{sq} object.
 Can be \code{NULL}.}

\item{...}{further arguments to be passed from or to other methods.}
}
\value{
An object with the format specified in the parameter. To find
information about the detailed structure of this object, see documentation
of these objects.
}
\description{
Converts object of class \code{\link[=sq-class]{sq}} to a class
from another package. Currently supported packages are \pkg{ape},
\pkg{bioseq}, \pkg{Bioconductor} and \pkg{seqinr}. For exact list of
supported classes and resulting types, see details.
}
\details{
Currently supported formats are as follows (grouped by \code{sq} types):
\itemize{
\item \strong{ami}:
 \itemize{
 \item \code{"ape::AAbin"}
 \item \code{"bioseq::bioseq_aa"}
 \item \code{"Biostrings::AAString"}
 \item \code{"Biostrings::AAStringSet"}
 \item \code{"seqinr::SeqFastaAA"}
 }
\item \strong{dna}:
 \itemize{
 \item \code{"ape::DNAbin"}
 \item \code{"bioseq::bioseq_dna"}
 \item \code{"Biostrings::DNAString"}
 \item \code{"Biostrings::DNAStringSet"}
 \item \code{"seqinr::SeqFastadna"}
 }
\item \strong{rna}:
 \itemize{
 \item \code{"bioseq::bioseq_rna"}
 \item \code{"Biostrings::RNAString"}
 \item \code{"Biostrings::RNAStringSet"}
 }
}
}
\examples{
\dontshow{if (all(c(require("Biostrings", quietly = TRUE), require("ape", quietly = TRUE), require("bioseq", quietly = TRUE), require("seqinr", quietly = TRUE)))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# DNA and amino acid sequences can be exported to most packages
sq_ami <- sq(c("MVVGL", "LAVPP"), alphabet = "ami_bsc")
export_sq(sq_ami, "ape::AAbin")
export_sq(sq_ami, "bioseq::bioseq_aa")
export_sq(sq_ami, "Biostrings::AAStringSet", c("one", "two"))
export_sq(sq_ami, "seqinr::SeqFastaAA")

sq_dna <- sq(c("TGATGAAGCGCA", "TTGATGGGAA"), alphabet = "dna_bsc")
export_sq(sq_dna, "ape::DNAbin", name = c("one", "two"))
export_sq(sq_dna, "bioseq::bioseq_dna")
export_sq(sq_dna, "Biostrings::DNAStringSet")
export_sq(sq_dna, "seqinr::SeqFastadna")

# RNA sequences are limited to Biostrings and bioseq
sq_rna <- sq(c("NUARYGCB", "", "DRKCNYBAU"), alphabet = "rna_ext")
export_sq(sq_rna, "bioseq::bioseq_rna")
export_sq(sq_rna, "Biostrings::RNAStringSet")

# Biostrings can export single sequences to simple strings as well
export_sq(sq_dna[1], "Biostrings::DNAString")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=sq-class]{sq class}}

Functions from output module:
\code{\link{as.character.sq}()},
\code{\link{as.matrix.sq}()},
\code{\link{as.sq}()},
\code{\link{write_fasta}()}
}
\concept{output_functions}
